/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import java.io.File;
import java.sql.SQLException;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.DatabaseStorage;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.NBTStorage;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.util.Util;
import org.bukkit.entity.EntityType;

public class NPCDataStore {
    private final Storage root;

    private NPCDataStore(Storage saves) {
        this.root = saves;
    }

    public void addPlotters(Metrics.Graph graph) {
        graph.addPlotter(new Metrics.Plotter("Database"){

            @Override
            public int getValue() {
                return NPCDataStore.this.root instanceof DatabaseStorage ? 1 : 0;
            }
        });
        graph.addPlotter(new Metrics.Plotter("YAML"){

            @Override
            public int getValue() {
                return NPCDataStore.this.root instanceof YamlStorage ? 1 : 0;
            }
        });
        graph.addPlotter(new Metrics.Plotter("NBT"){

            @Override
            public int getValue() {
                return NPCDataStore.this.root instanceof NBTStorage ? 1 : 0;
            }
        });
    }

    public void loadInto(CitizensNPCRegistry registry) {
        int created = 0;
        for (DataKey key : this.root.getKey("npc").getIntegerSubKeys()) {
            int id = Integer.parseInt(key.name());
            if (!key.keyExists("name")) {
                Messaging.logTr("citizens.notifications.npc-name-not-found", id);
                continue;
            }
            String unparsedEntityType = key.getString("traits.type", "PLAYER");
            EntityType type = Util.matchEntityType(unparsedEntityType);
            if (type == null) {
                Messaging.logTr("citizens.notifications.unknown-npc-type", unparsedEntityType);
                continue;
            }
            NPC npc = registry.createNPC(type, id, key.getString("name"));
            ((CitizensNPC)npc).load(key);
            ++created;
        }
        Messaging.logTr("citizens.notifications.npcs-loaded", created, "?");
    }

    public void remove(NPC npc) {
        this.root.getKey("npc").removeKey(Integer.toString(npc.getId()));
    }

    public void saveToDisk() {
        new Thread(){

            @Override
            public void run() {
                NPCDataStore.this.root.save();
            }
        }.start();
    }

    public void saveToDiskImmediate() {
        this.root.save();
    }

    public void store(NPC npc) {
        ((CitizensNPC)npc).save(this.root.getKey("npc." + npc.getId()));
    }

    public void storeAll(NPCRegistry registry) {
        for (NPC npc : registry) {
            this.store(npc);
        }
    }

    public static NPCDataStore create(File folder) {
        Storage saves = null;
        String type = Settings.Setting.STORAGE_TYPE.asString();
        if (type.equalsIgnoreCase("db") || type.equalsIgnoreCase("database")) {
            try {
                saves = new DatabaseStorage(Settings.Setting.DATABASE_DRIVER.asString(), Settings.Setting.DATABASE_URL.asString(), Settings.Setting.DATABASE_USERNAME.asString(), Settings.Setting.DATABASE_PASSWORD.asString());
            }
            catch (SQLException e) {
                e.printStackTrace();
                Messaging.logTr("citizens.notifications.database-connection-failed", new Object[0]);
            }
        } else if (type.equalsIgnoreCase("nbt")) {
            saves = new NBTStorage(folder + File.separator + Settings.Setting.STORAGE_FILE.asString(), "Citizens NPC Storage");
        }
        if (saves == null) {
            saves = new YamlStorage(new File(folder, Settings.Setting.STORAGE_FILE.asString()), "Citizens NPC Storage");
        }
        if (!saves.load()) {
            return null;
        }
        return new NPCDataStore(saves);
    }
}

