/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;

public class Selector
extends Composite {
    private Behavior executing;
    private boolean retryChildren = false;
    private final Function<List<Behavior>, Behavior> selectionFunction;
    private int x;
    private static final Random RANDOM = new Random();
    private static final Function<List<Behavior>, Behavior> RANDOM_SELECTION = new Function<List<Behavior>, Behavior>(){

        public Behavior apply(@Nullable List<Behavior> behaviors) {
            return behaviors.get(RANDOM.nextInt(behaviors.size()));
        }
    };

    private Selector(Function<List<Behavior>, Behavior> selectionFunction, boolean retryChildren, Collection<Behavior> behaviors) {
        super(behaviors);
        this.selectionFunction = selectionFunction;
        this.retryChildren = retryChildren;
    }

    protected Behavior getNextBehavior() {
        Behavior behavior = null;
        while ((behavior = (Behavior)this.selectionFunction.apply(this.getBehaviors())) instanceof ParallelBehavior) {
            this.addParallel(behavior);
            ++this.x;
        }
        return behavior;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.executing != null) {
            this.executing.reset();
        }
        this.executing = null;
    }

    @Override
    public BehaviorStatus run() {
        if (this.executing == null) {
            this.executing = this.getNextBehavior();
        }
        this.tickParallel();
        BehaviorStatus status = this.executing.run();
        if (status == BehaviorStatus.FAILURE) {
            if (this.retryChildren) {
                this.executing.reset();
                this.executing = this.getNextBehavior();
                return BehaviorStatus.RUNNING;
            }
        } else if (status == BehaviorStatus.RESET_AND_REMOVE) {
            this.getBehaviors().remove(this.executing);
            return BehaviorStatus.SUCCESS;
        }
        return status;
    }

    public static void main(String[] args) {
        ArrayList b = Lists.newArrayList((Object[])new Behavior[]{new empty()});
        for (int i = 0; i < 1000; ++i) {
            b.add(Math.random() < 0.001 ? new empty() : new emptyo());
        }
        Selector sel = Selector.selecting(b).build();
        for (int i = 0; i < 500; ++i) {
            sel.run();
        }
        System.err.println(sel.x + " " + sel.getBehaviors().size());
    }

    public static Builder selecting(Behavior ... behaviors) {
        return Selector.selecting(Arrays.asList(behaviors));
    }

    public static Builder selecting(Collection<Behavior> behaviors) {
        return new Builder(behaviors);
    }

    static /* synthetic */ Function access$000() {
        return RANDOM_SELECTION;
    }

    private static class emptyo
    extends BehaviorGoalAdapter
    implements ParallelBehavior {
        private emptyo() {
        }

        @Override
        public void reset() {
        }

        @Override
        public BehaviorStatus run() {
            return BehaviorStatus.SUCCESS;
        }

        @Override
        public boolean shouldExecute() {
            return true;
        }
    }

    private static class empty
    extends BehaviorGoalAdapter {
        private empty() {
        }

        @Override
        public void reset() {
        }

        @Override
        public BehaviorStatus run() {
            return null;
        }

        @Override
        public boolean shouldExecute() {
            return false;
        }
    }

    public static class Builder {
        private final Collection<Behavior> behaviors;
        private boolean retryChildren;
        private Function<List<Behavior>, Behavior> selectionFunction = Selector.access$000();

        private Builder(Collection<Behavior> behaviors) {
            this.behaviors = behaviors;
        }

        public Selector build() {
            return new Selector(this.selectionFunction, this.retryChildren, this.behaviors);
        }

        public Builder retryChildren(boolean retry) {
            this.retryChildren = retry;
            return this;
        }

        public Builder selectionFunction(Function<List<Behavior>, Behavior> function) {
            this.selectionFunction = function;
            return this;
        }
    }
}

