/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_R1.EntityGiantZombie;
import net.minecraft.server.v1_4_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_4_R1.CraftServer;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftGiant;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Giant;
import org.bukkit.util.Vector;

public class GiantController
extends MobEntityController {
    public GiantController() {
        super(EntityGiantNPC.class);
    }

    public Giant getBukkitEntity() {
        return (Giant)super.getBukkitEntity();
    }

    public static class GiantNPC
    extends CraftGiant
    implements NPCHolder {
        private final CitizensNPC npc;

        public GiantNPC(EntityGiantNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityGiantZombie)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityGiantNPC
    extends EntityGiantZombie
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGiantNPC(World world) {
            this(world, null);
        }

        public EntityGiantNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void bn() {
            if (this.npc == null) {
                super.bn();
            } else {
                this.npc.update();
            }
        }

        public void collide(net.minecraft.server.v1_4_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new GiantNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

