/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;

public class Sequence
extends Composite {
    private Behavior executing;
    private int executingIndex;
    private final boolean retryChildren;

    private Sequence(boolean retryChildren, Behavior ... behaviors) {
        this(retryChildren, Arrays.asList(behaviors));
    }

    private Sequence(boolean retryChildren, Collection<Behavior> behaviors) {
        super(behaviors);
        this.retryChildren = retryChildren;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.executing != null) {
            this.executing.reset();
        }
        this.executing = null;
        this.executingIndex = 0;
    }

    @Override
    public BehaviorStatus run() {
        List<Behavior> behaviors = this.getBehaviors();
        if (this.executing == null) {
            while ((this.executing = behaviors.get(this.executingIndex)) instanceof ParallelBehavior) {
                this.addParallel(this.executing);
                ++this.executingIndex;
                if (this.executingIndex < behaviors.size()) continue;
                return BehaviorStatus.SUCCESS;
            }
            if (!this.executing.shouldExecute()) {
                if (this.retryChildren) {
                    this.executing = null;
                    return BehaviorStatus.RUNNING;
                }
                return BehaviorStatus.FAILURE;
            }
        }
        this.tickParallel();
        BehaviorStatus status = this.executing.run();
        switch (status) {
            case RUNNING: {
                return BehaviorStatus.RUNNING;
            }
            case FAILURE: {
                if (!this.retryChildren) {
                    return BehaviorStatus.FAILURE;
                }
                this.executing = null;
                return BehaviorStatus.RUNNING;
            }
            case RESET_AND_REMOVE: {
                behaviors.remove(this.executingIndex);
                return this.selectNext(behaviors);
            }
            case SUCCESS: {
                ++this.executingIndex;
                return this.selectNext(behaviors);
            }
        }
        throw new IllegalStateException();
    }

    private BehaviorStatus selectNext(List<Behavior> behaviors) {
        if (this.executingIndex >= behaviors.size()) {
            return BehaviorStatus.SUCCESS;
        }
        while ((this.executing = behaviors.get(this.executingIndex)) instanceof ParallelBehavior) {
            this.addParallel(this.executing);
            ++this.executingIndex;
            if (this.executingIndex < behaviors.size()) continue;
            return BehaviorStatus.SUCCESS;
        }
        if (!this.executing.shouldExecute() && !this.retryChildren) {
            return BehaviorStatus.FAILURE;
        }
        return BehaviorStatus.RUNNING;
    }

    public static Sequence createRetryingSequence(Behavior ... behaviors) {
        return Sequence.createRetryingSequence(Arrays.asList(behaviors));
    }

    public static Sequence createRetryingSequence(Collection<Behavior> behaviors) {
        return new Sequence(true, behaviors);
    }

    public static Sequence createSequence(Behavior ... behaviors) {
        return Sequence.createSequence(Arrays.asList(behaviors));
    }

    public static Sequence createSequence(Collection<Behavior> behaviors) {
        return new Sequence(false, behaviors);
    }
}

