/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.text.TextStartPrompt;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;

public class PageChangePrompt
extends NumericPrompt {
    private final Text text;

    public PageChangePrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptValidatedInput(ConversationContext context, Number input) {
        Player player = (Player)context.getForWhom();
        if (!this.text.sendPage(player, input.intValue())) {
            Messaging.sendErrorTr((CommandSender)player, "citizens.editors.text.invalid-page", new Object[0]);
            return new TextStartPrompt(this.text);
        }
        return (Prompt)context.getSessionData((Object)"previous");
    }

    public String getFailedValidationText(ConversationContext context, String input) {
        return ChatColor.RED + Messaging.tr("citizens.editors.text.invalid-page", new Object[0]);
    }

    public String getPromptText(ConversationContext context) {
        return Messaging.tr("citizens.editors.text.change-page-prompt", new Object[0]);
    }
}

