/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public abstract class Composite
extends BehaviorGoalAdapter {
    private final List<Behavior> behaviors;
    private final Collection<Behavior> parallelExecuting = Lists.newArrayListWithCapacity((int)0);

    public Composite(Behavior ... behaviors) {
        this(Arrays.asList(behaviors));
    }

    protected void prepareForExecution(Behavior behavior) {
        if (behavior == null) {
            return;
        }
        CitizensAPI.registerEvents(behavior);
    }

    public Composite(Collection<Behavior> behaviors) {
        this.behaviors = Lists.newArrayList(behaviors);
        boolean foundNonParallel = false;
        for (Behavior behavior : behaviors) {
            if (behavior instanceof ParallelBehavior) continue;
            foundNonParallel = true;
            break;
        }
        if (!foundNonParallel) {
            throw new IllegalStateException("must have at least one non-parallel node");
        }
    }

    public void addBehavior(Behavior behavior) {
        this.behaviors.add(behavior);
    }

    protected void addParallel(Behavior behavior) {
        if (behavior.shouldExecute() && !this.parallelExecuting.contains(behavior)) {
            this.parallelExecuting.add(behavior);
            this.prepareForExecution(behavior);
        }
    }

    protected List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void removeBehavior(Behavior behavior) {
        this.behaviors.remove(behavior);
    }

    @Override
    public void reset() {
        if (this.parallelExecuting.size() > 0) {
            for (Behavior behavior : this.parallelExecuting) {
                behavior.reset();
            }
            this.parallelExecuting.clear();
        }
    }

    @Override
    public boolean shouldExecute() {
        return this.behaviors.size() > 0;
    }

    protected void stopExecution(Behavior behavior) {
        if (behavior == null) {
            return;
        }
        HandlerList.unregisterAll((Listener)behavior);
        behavior.reset();
    }

    protected void tickParallel() {
        Iterator<Behavior> itr = this.parallelExecuting.iterator();
        while (itr.hasNext()) {
            Behavior behavior = itr.next();
            BehaviorStatus status = behavior.run();
            switch (status) {
                case RESET_AND_REMOVE: {
                    this.behaviors.remove(behavior);
                }
                case FAILURE: 
                case SUCCESS: {
                    itr.remove();
                    this.stopExecution(behavior);
                    break;
                }
            }
        }
    }
}

