/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.util.Colorizer;
import org.bukkit.ChatColor;

public class StringHelper {
    public static String capitalize(Object string) {
        String capitalize = string.toString();
        return capitalize.length() == 0 ? "" : Character.toUpperCase(capitalize.charAt(0)) + capitalize.substring(1, capitalize.length());
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static String wrap(Object string) {
        return StringHelper.wrap(string, Colorizer.parseColors(Settings.Setting.MESSAGE_COLOUR.asString()));
    }

    public static String wrap(Object string, ChatColor colour) {
        return StringHelper.wrap(string, colour.toString());
    }

    public static String wrap(Object string, String colour) {
        return Colorizer.parseColors(Settings.Setting.HIGHLIGHT_COLOUR.asString()) + string.toString() + colour;
    }

    public static String wrapHeader(Object string) {
        String highlight = Settings.Setting.HIGHLIGHT_COLOUR.asString();
        return highlight + "=====[ " + string.toString() + highlight + " ]=====";
    }
}

