/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.Selector;

public class Selectors {
    private Selectors() {
    }

    public static Selector.Builder prioritySelector(Comparator<Behavior> comparator, Behavior ... behaviors) {
        return Selectors.prioritySelector(comparator, Arrays.asList(behaviors));
    }

    public static Selector.Builder prioritySelector(final Comparator<Behavior> comparator, Collection<Behavior> behaviors) {
        Preconditions.checkArgument((behaviors.size() > 0 ? 1 : 0) != 0, (Object)"must have at least one behavior for comparison");
        return Selector.selecting(behaviors).selectionFunction(new Function<List<Behavior>, Behavior>(){

            public Behavior apply(@Nullable List<Behavior> input) {
                Collections.sort(input, comparator);
                return input.get(input.size() - 1);
            }
        });
    }
}

