/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class VectorNode
extends AStarNode
implements PathPoint {
    private float blockCost = -1.0f;
    final BlockSource blockSource;
    List<PathPoint.PathCallback> callbacks;
    private final BlockExaminer[] examiners;
    final Vector location;

    public VectorNode(Location location, BlockSource source, BlockExaminer ... examiners) {
        this(location.toVector(), source, examiners);
    }

    public VectorNode(Vector location, BlockSource source, BlockExaminer ... examiners) {
        this.location = location.setX(location.getBlockX()).setY(location.getBlockY()).setZ(location.getBlockZ());
        this.blockSource = source;
        this.examiners = examiners == null ? new BlockExaminer[]{} : examiners;
    }

    @Override
    public void addCallback(PathPoint.PathCallback callback) {
        if (this.callbacks == null) {
            this.callbacks = Lists.newArrayList();
        }
        this.callbacks.add(callback);
    }

    @Override
    public Plan buildPlan() {
        Iterable<VectorNode> parents = this.getParents();
        return new Path(parents);
    }

    public float distance(VectorNode to) {
        return (float)this.location.distanceSquared(to.location);
    }

    private float getBlockCost() {
        if (this.blockCost == -1.0f) {
            this.blockCost = 0.0f;
            for (BlockExaminer examiner : this.examiners) {
                this.blockCost += examiner.getCost(this.blockSource, this);
            }
        }
        return this.blockCost;
    }

    @Override
    public Iterable<AStarNode> getNeighbours() {
        ArrayList nodes = Lists.newArrayList();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    VectorNode sub;
                    Vector mod;
                    if (x == 0 && y == 0 && z == 0 || (mod = this.location.clone().add(new Vector(x, y, z))).equals((Object)this.location) || !this.isPassable(sub = this.getNewNode(mod))) continue;
                    nodes.add(sub);
                }
            }
        }
        return nodes;
    }

    private VectorNode getNewNode(Vector mod) {
        return new VectorNode(mod, this.blockSource, this.examiners);
    }

    @Override
    public Vector getVector() {
        return this.location;
    }

    public float heuristicDistance(Vector goal) {
        return (float)this.location.distanceSquared(goal) + this.getBlockCost();
    }

    private boolean isPassable(PathPoint mod) {
        for (BlockExaminer examiner : this.examiners) {
            boolean passable = examiner.isPassable(this.blockSource, mod);
            if (passable) continue;
            return false;
        }
        return true;
    }
}

