/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import java.io.IOException;
import java.util.List;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.network.EmptyNetHandler;
import net.citizensnpcs.npc.network.EmptyNetworkManager;
import net.citizensnpcs.npc.network.EmptySocket;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_R1.Connection;
import net.minecraft.server.v1_4_R1.EntityLiving;
import net.minecraft.server.v1_4_R1.EntityPlayer;
import net.minecraft.server.v1_4_R1.EnumGamemode;
import net.minecraft.server.v1_4_R1.MinecraftServer;
import net.minecraft.server.v1_4_R1.Navigation;
import net.minecraft.server.v1_4_R1.Packet;
import net.minecraft.server.v1_4_R1.Packet5EntityEquipment;
import net.minecraft.server.v1_4_R1.PlayerInteractManager;
import net.minecraft.server.v1_4_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.CraftServer;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder {
    private final Location cachedEquipmentLocation = new Location(null, 0.0, 0.0, 0.0);
    private final CitizensNPC npc;
    private static final float EPSILON = 0.005f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, World world, String string, PlayerInteractManager playerInteractManager, NPC npc) {
        super(minecraftServer, world, string, playerInteractManager);
        playerInteractManager.setGameMode(EnumGamemode.SURVIVAL);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.initialise(minecraftServer);
        }
    }

    public float bB() {
        return super.bB() * this.npc.getNavigator().getLocalParameters().speed();
    }

    public void collide(net.minecraft.server.v1_4_R1.Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void g(double x, double y, double z) {
        if (this.npc == null) {
            super.g(x, y, z);
            return;
        }
        if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
            if (!this.npc.data().get("protected", true).booleanValue()) {
                super.g(x, y, z);
            }
            return;
        }
        Vector vector = new Vector(x, y, z);
        NPCPushEvent event = Util.callPushEvent(this.npc, vector);
        if (!event.isCancelled()) {
            vector = event.getCollisionVector();
            super.g(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && this.bukkitEntity == null) {
            this.bukkitEntity = new PlayerNPC(this);
        }
        return super.getBukkitEntity();
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(socket, "npc mgr", new Connection(){

                public boolean a() {
                    return false;
                }
            }, this.server.F().getPrivate());
            this.playerConnection = new EmptyNetHandler(minecraftServer, conn, this);
            conn.a((Connection)this.playerConnection);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.getNavigation().e(true);
        this.X = 1.0f;
        try {
            socket.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void j_() {
        super.j_();
        if (this.npc == null) {
            return;
        }
        if (this.getBukkitEntity() != null && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && !this.npc.getNavigator().isNavigating() && !NMS.inWater((LivingEntity)this.getBukkitEntity())) {
            this.move(0.0, -0.2, 0.0);
        }
        this.updateEquipment();
        if (!this.npc.data().get("removefromplayerlist", true).booleanValue()) {
            this.g();
        }
        if (Math.abs(this.motX) < (double)0.005f && Math.abs(this.motY) < (double)0.005f && Math.abs(this.motZ) < (double)0.005f) {
            this.motZ = 0.0;
            this.motY = 0.0;
            this.motX = 0.0;
        }
        NMS.updateSenses((EntityLiving)this);
        if (this.npc.getNavigator().isNavigating()) {
            Navigation navigation = this.getNavigation();
            if (!navigation.f()) {
                navigation.e();
            }
            this.moveOnCurrentHeading();
        } else if (this.motX != 0.0 || this.motZ != 0.0 || this.motY != 0.0) {
            this.e(0.0f, 0.0f);
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        this.npc.update();
    }

    private void moveOnCurrentHeading() {
        NMS.updateAI((EntityLiving)this);
        if (this.bF) {
            if (this.onGround && this.bV == 0.0) {
                this.bi();
                this.bV = 10.0;
            }
        } else {
            this.bV = 0.0;
        }
        this.bC *= 0.98f;
        this.bD *= 0.98f;
        this.bE *= 0.9f;
        float prev = this.aN;
        this.aN *= this.bB();
        this.e(this.bC, this.bD);
        this.aN = prev;
        NMS.setHeadYaw((EntityLiving)this, this.yaw);
    }

    private void updateEquipment() {
        for (int i = 0; i < 5; ++i) {
            NMS.sendPacketNearby(this.getBukkitEntity().getLocation(this.cachedEquipmentLocation), (Packet)new Packet5EntityEquipment(this.id, i, this.getEquipment(i)));
        }
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.server.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean hasMetadata(String metadataKey) {
            return this.server.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.server.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.server.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }
    }
}

