/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.ContextProvider;

public class ScriptCompiler
implements Runnable {
    private final WeakReference<ClassLoader> classLoader;
    private final ScriptEngineManager engineManager;
    private final Map<String, ScriptEngine> engines = Maps.newHashMap();
    private final Function<File, FileEngine> fileEngineConverter = new Function<File, FileEngine>(){

        public FileEngine apply(File file) {
            if (!file.isFile()) {
                return null;
            }
            String fileName = file.getName();
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            ScriptEngine engine = ScriptCompiler.this.loadEngine(extension);
            if (engine == null) {
                return null;
            }
            return new FileEngine(file, engine);
        }
    };
    private final List<ContextProvider> globalContextProviders = Lists.newArrayList();
    private final Thread runningThread;
    private final BlockingQueue<CompileTask> toCompile = new ArrayBlockingQueue<CompileTask>(50);

    public ScriptCompiler(ClassLoader classLoader) {
        this.engineManager = new ScriptEngineManager(classLoader);
        this.runningThread = new Thread((Runnable)this, "Citizens Script Compiler");
        this.runningThread.setContextClassLoader(classLoader);
        this.runningThread.start();
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
    }

    public CompileTaskBuilder compile(File ... files) {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("files should have a length of at least one");
        }
        ArrayList toCompile = Lists.newArrayList();
        for (File file : files) {
            FileEngine res = (FileEngine)this.fileEngineConverter.apply((Object)file);
            if (res == null) continue;
            toCompile.add(res);
        }
        return new CompileTaskBuilder(toCompile.toArray(new FileEngine[toCompile.size()]));
    }

    public CompileTaskBuilder compile(Iterable<File> files) {
        return this.compile((File[])Iterables.toArray(files, File.class));
    }

    public void interrupt() {
        this.runningThread.interrupt();
    }

    private ScriptEngine loadEngine(String extension) {
        ScriptEngine engine = this.engines.get(extension);
        if (engine == null) {
            ClassLoader replace = (ClassLoader)this.classLoader.get();
            ClassLoader old = null;
            if (replace != null) {
                old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(replace);
            }
            ScriptEngine search = this.engineManager.getEngineByExtension(extension);
            if (replace != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
            if (!(search == null || search instanceof Compilable && search instanceof Invocable)) {
                search = null;
            }
            this.engines.put(extension, search);
        }
        return engine;
    }

    public void registerGlobalContextProvider(ContextProvider provider) {
        if (!this.globalContextProviders.contains(provider)) {
            this.globalContextProviders.add(provider);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void run(String code, String extension) throws ScriptException {
        this.run(code, extension, null);
    }

    public void run(String code, String extension, Map<String, Object> vars) throws ScriptException {
        ScriptEngine engine = this.loadEngine(extension);
        if (engine == null) {
            throw new ScriptException("Couldn't load engine with extension " + extension);
        }
        SimpleScriptContext context = new SimpleScriptContext();
        if (vars != null) {
            context.setBindings(new SimpleBindings(vars), 100);
        }
        engine.eval(extension, (ScriptContext)context);
    }

    private static class FileEngine {
        final ScriptEngine engine;
        final File file;

        FileEngine(File file, ScriptEngine engine) {
            this.file = file;
            this.engine = engine;
        }
    }

    public class CompileTaskBuilder {
        private final List<CompileCallback> callbacks = Lists.newArrayList();
        private final List<ContextProvider> contextProviders = Lists.newArrayList();
        private final FileEngine[] files;

        private CompileTaskBuilder(FileEngine[] files) {
            this.files = files;
        }

        public boolean begin() {
            return ScriptCompiler.this.toCompile.offer(new CompileTask(this));
        }

        public CompileTaskBuilder withCallback(CompileCallback callback) {
            this.callbacks.add(callback);
            return this;
        }

        public CompileTaskBuilder withContextProvider(ContextProvider provider) {
            this.contextProviders.add(provider);
            return this;
        }
    }

    private class CompileTask {
        private final CompileCallback[] callbacks;
        private final ContextProvider[] contextProviders;
        private final FileEngine[] files;

        public CompileTask(CompileTaskBuilder builder) {
            ArrayList copy = Lists.newArrayList((Iterable)builder.contextProviders);
            copy.addAll(ScriptCompiler.this.globalContextProviders);
            this.contextProviders = copy.toArray(new ContextProvider[copy.size()]);
            this.files = builder.files;
            this.callbacks = builder.callbacks.toArray(new CompileCallback[builder.callbacks.size()]);
        }

        static /* synthetic */ FileEngine[] access$200(CompileTask x0) {
            return x0.files;
        }

        static /* synthetic */ ContextProvider[] access$300(CompileTask x0) {
            return x0.contextProviders;
        }

        static /* synthetic */ CompileCallback[] access$400(CompileTask x0) {
            return x0.callbacks;
        }
    }
}

