/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_R1.EntitySquid;
import net.minecraft.server.v1_4_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_4_R1.CraftServer;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftSquid;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Squid;
import org.bukkit.util.Vector;

public class SquidController
extends MobEntityController {
    public SquidController() {
        super(EntitySquidNPC.class);
    }

    public Squid getBukkitEntity() {
        return (Squid)super.getBukkitEntity();
    }

    public static class SquidNPC
    extends CraftSquid
    implements NPCHolder {
        private final CitizensNPC npc;

        public SquidNPC(EntitySquidNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntitySquid)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntitySquidNPC
    extends EntitySquid
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntitySquidNPC(World world) {
            this(world, null);
        }

        public EntitySquidNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public float bB() {
            return this.npc == null ? super.bB() : super.bB() * this.npc.getNavigator().getLocalParameters().speed();
        }

        public void bn() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.bn();
            }
        }

        public void collide(net.minecraft.server.v1_4_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new SquidNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

