/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.trait.text.TextStartPrompt;
import net.citizensnpcs.util.Paginator;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Text
extends Trait
implements Runnable,
Toggleable,
Listener,
ConversationAbandonedListener {
    private final Map<String, Date> cooldowns = new HashMap<String, Date>();
    private int currentIndex;
    private String itemInHandPattern = "default";
    private final Plugin plugin;
    private boolean randomTalker = Settings.Setting.DEFAULT_RANDOM_TALKER.asBoolean();
    private double range = Settings.Setting.DEFAULT_TALK_CLOSE_RANGE.asDouble();
    private boolean realisticLooker = Settings.Setting.DEFAULT_REALISTIC_LOOKING.asBoolean();
    private boolean talkClose = Settings.Setting.DEFAULT_TALK_CLOSE.asBoolean();
    private final List<String> text = new ArrayList<String>();
    private static Random RANDOM = Util.getFastRandom();

    public Text() {
        super("text");
        this.plugin = CitizensAPI.getPlugin();
    }

    void add(String string) {
        this.text.add(string);
    }

    public void conversationAbandoned(ConversationAbandonedEvent event) {
        Bukkit.dispatchCommand((CommandSender)((Player)event.getContext().getForWhom()), (String)"npc text");
    }

    void edit(int index, String newText) {
        this.text.set(index, newText);
    }

    public Editor getEditor(final Player player) {
        final Conversation conversation = new ConversationFactory(this.plugin).addConversationAbandonedListener((ConversationAbandonedListener)this).withLocalEcho(false).withEscapeSequence("/npc text").withEscapeSequence("exit").withModality(false).withFirstPrompt((Prompt)new TextStartPrompt(this)).buildConversation((Conversable)player);
        return new Editor(){

            @Override
            public void begin() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.text.begin", new Object[0]);
                conversation.begin();
            }

            @Override
            public void end() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.text.end", new Object[0]);
                conversation.abandon();
            }
        };
    }

    boolean hasIndex(int index) {
        return index >= 0 && this.text.size() > index;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.text.clear();
        for (DataKey sub : key.getIntegerSubKeys()) {
            this.text.add(sub.getString(""));
        }
        for (DataKey sub : key.getRelative("text").getIntegerSubKeys()) {
            this.text.add(sub.getString(""));
        }
        if (this.text.isEmpty()) {
            this.populateDefaultText();
        }
        this.talkClose = key.getBoolean("talk-close", this.talkClose);
        this.realisticLooker = key.getBoolean("realistic-looking", this.realisticLooker);
        this.randomTalker = key.getBoolean("random-talker", this.randomTalker);
        this.range = key.getDouble("range", this.range);
        this.itemInHandPattern = key.getString("talkitem", this.itemInHandPattern);
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        String localPattern;
        if (!event.getNPC().equals(this.npc)) {
            return;
        }
        String string = localPattern = this.itemInHandPattern.equals("default") ? Settings.Setting.TALK_ITEM.asString() : this.itemInHandPattern;
        if (Util.matchesItemInHand(event.getClicker(), localPattern) && !this.shouldTalkClose()) {
            this.sendText(event.getClicker());
        }
    }

    private void populateDefaultText() {
        this.text.addAll(Settings.Setting.DEFAULT_TEXT.asList());
    }

    void remove(int index) {
        this.text.remove(index);
    }

    @Override
    public void run() {
        if (!this.talkClose || !this.npc.isSpawned()) {
            return;
        }
        List nearby = this.npc.getBukkitEntity().getNearbyEntities(this.range, this.range, this.range);
        for (Entity search : nearby) {
            if (!(search instanceof Player)) continue;
            Player player = (Player)search;
            Date cooldown = this.cooldowns.get(player.getName());
            if (cooldown != null) {
                if (!new Date().after(cooldown)) {
                    return;
                }
                this.cooldowns.remove(player.getName());
            }
            if (!this.sendText(player)) {
                return;
            }
            Date wait = new Date();
            int secondsDelta = RANDOM.nextInt(Settings.Setting.TALK_CLOSE_MAXIMUM_COOLDOWN.asInt()) + Settings.Setting.TALK_CLOSE_MINIMUM_COOLDOWN.asInt();
            if (secondsDelta <= 0) {
                return;
            }
            long millisecondsDelta = TimeUnit.MILLISECONDS.convert(secondsDelta, TimeUnit.SECONDS);
            wait.setTime(wait.getTime() + millisecondsDelta);
            this.cooldowns.put(player.getName(), wait);
        }
    }

    @Override
    public void save(DataKey key) {
        int i;
        key.setBoolean("talk-close", this.talkClose);
        key.setBoolean("random-talker", this.randomTalker);
        key.setBoolean("realistic-looking", this.realisticLooker);
        key.setDouble("range", this.range);
        key.setString("talkitem", this.itemInHandPattern);
        for (i = 0; i < 100; ++i) {
            key.removeKey(String.valueOf(i));
        }
        key.removeKey("text");
        for (i = 0; i < this.text.size(); ++i) {
            key.setString("text." + String.valueOf(i), this.text.get(i));
        }
    }

    boolean sendPage(Player player, int page) {
        Paginator paginator = new Paginator().header(this.npc.getName() + "'s Text Entries");
        for (int i = 0; i < this.text.size(); ++i) {
            paginator.addLine("<a>" + i + " <7>- <e>" + this.text.get(i));
        }
        return paginator.sendPage((CommandSender)player, page);
    }

    private boolean sendText(Player player) {
        if (!player.hasPermission("citizens.admin") && !player.hasPermission("citizens.npc.talk")) {
            return false;
        }
        if (this.text.size() == 0) {
            return false;
        }
        int index = 0;
        if (this.randomTalker) {
            index = new Random().nextInt(this.text.size());
        } else {
            if (this.currentIndex > this.text.size() - 1) {
                this.currentIndex = 0;
            }
            index = this.currentIndex++;
        }
        this.npc.getDefaultSpeechController().speak(new SpeechContext(this.text.get(index), (LivingEntity)player));
        return true;
    }

    void setItemInHandPattern(String pattern) {
        this.itemInHandPattern = pattern;
    }

    void setRange(double range) {
        this.range = range;
    }

    boolean shouldTalkClose() {
        return this.talkClose;
    }

    @Override
    public boolean toggle() {
        this.talkClose = !this.talkClose;
        return this.talkClose;
    }

    boolean toggleRandomTalker() {
        this.randomTalker = !this.randomTalker;
        return this.randomTalker;
    }

    boolean toggleRealisticLooking() {
        this.realisticLooker = !this.realisticLooker;
        return this.realisticLooker;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Text{talk-close=" + this.talkClose + ",text=");
        for (String line : this.text) {
            builder.append(line + ",");
        }
        builder.append("}");
        return builder.toString();
    }
}

