/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_4_R1.ControllerJump;
import net.minecraft.server.v1_4_R1.ControllerLook;
import net.minecraft.server.v1_4_R1.DamageSource;
import net.minecraft.server.v1_4_R1.EnchantmentManager;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityLiving;
import net.minecraft.server.v1_4_R1.EntityMonster;
import net.minecraft.server.v1_4_R1.EntityPlayer;
import net.minecraft.server.v1_4_R1.EntityTypes;
import net.minecraft.server.v1_4_R1.MathHelper;
import net.minecraft.server.v1_4_R1.MobEffectList;
import net.minecraft.server.v1_4_R1.Navigation;
import net.minecraft.server.v1_4_R1.NetworkManager;
import net.minecraft.server.v1_4_R1.Packet;
import net.minecraft.server.v1_4_R1.PathfinderGoalSelector;
import net.minecraft.server.v1_4_R1.World;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_4_R1.CraftServer;
import org.bukkit.craftbukkit.v1_4_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.material.Stairs;
import org.bukkit.material.Step;
import org.bukkit.plugin.PluginLoadOrder;

public class NMS {
    private static final float DEFAULT_SPEED = 0.4f;
    private static Map<Class<?>, Integer> ENTITY_CLASS_TO_INT;
    private static final Map<Class<?>, Constructor<?>> ENTITY_CONSTRUCTOR_CACHE;
    private static Map<Integer, Class<?>> ENTITY_INT_TO_CLASS;
    private static Field GOAL_FIELD;
    private static Field LAND_SPEED_MODIFIER_FIELD;
    private static final Map<EntityType, Float> MOVEMENT_SPEEDS;
    private static Field NAVIGATION_WORLD_FIELD;
    private static final Location packetCacheLocation;
    private static Field PATHFINDING_RANGE;
    private static final Random RANDOM;
    private static Set<Integer> SLAB_MATERIALS;
    private static Field SPEED_FIELD;
    private static Set<Integer> STAIR_MATERIALS;
    private static Field THREAD_STOPPER;

    private NMS() {
    }

    public static void addOrRemoveFromPlayerList(LivingEntity bukkitEntity, boolean remove) {
        if (bukkitEntity == null) {
            return;
        }
        EntityLiving handle = NMS.getHandle(bukkitEntity);
        if (handle.world == null) {
            return;
        }
        if (remove) {
            handle.world.players.remove(handle);
        } else if (!handle.world.players.contains(handle)) {
            handle.world.players.add(handle);
        }
    }

    public static void attack(EntityLiving handle, EntityLiving target) {
        int fireAspectLevel;
        boolean success;
        int damage;
        int n = damage = handle instanceof EntityMonster ? ((EntityMonster)handle).c((Entity)target) : 2;
        if (handle.hasEffect(MobEffectList.INCREASE_DAMAGE)) {
            damage += 3 << handle.getEffect(MobEffectList.INCREASE_DAMAGE).getAmplifier();
        }
        if (handle.hasEffect(MobEffectList.WEAKNESS)) {
            damage -= 2 << handle.getEffect(MobEffectList.WEAKNESS).getAmplifier();
        }
        int knockbackLevel = 0;
        if (target instanceof EntityLiving) {
            damage += EnchantmentManager.a((EntityLiving)handle, (EntityLiving)target);
            knockbackLevel += EnchantmentManager.getKnockbackEnchantmentLevel((EntityLiving)handle, (EntityLiving)target);
        }
        if (!(success = target.damageEntity(DamageSource.mobAttack((EntityLiving)handle), damage))) {
            return;
        }
        if (knockbackLevel > 0) {
            target.g((double)(-MathHelper.sin((float)((float)((double)handle.yaw * Math.PI / 180.0))) * (float)knockbackLevel * 0.5f), 0.1, (double)(MathHelper.cos((float)((float)((double)handle.yaw * Math.PI / 180.0))) * (float)knockbackLevel * 0.5f));
            handle.motX *= 0.6;
            handle.motZ *= 0.6;
        }
        if ((fireAspectLevel = EnchantmentManager.getFireAspectEnchantmentLevel((EntityLiving)handle)) > 0) {
            target.setOnFire(fireAspectLevel * 4);
        }
    }

    public static void clearGoals(PathfinderGoalSelector ... goalSelectors) {
        if (GOAL_FIELD == null || goalSelectors == null) {
            return;
        }
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                List list = (List)GOAL_FIELD.get(selector);
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getMessage());
            }
        }
    }

    private static Constructor<?> getCustomEntityConstructor(Class<?> clazz, EntityType type) throws SecurityException, NoSuchMethodException {
        Constructor<?> constructor = ENTITY_CONSTRUCTOR_CACHE.get(clazz);
        if (constructor == null) {
            constructor = clazz.getConstructor(World.class);
            constructor.setAccessible(true);
            ENTITY_CLASS_TO_INT.put(clazz, Integer.valueOf(type.getTypeId()));
            ENTITY_CONSTRUCTOR_CACHE.put(clazz, constructor);
        }
        return constructor;
    }

    private static Field getField(Class<?> clazz, String field) {
        Field f = null;
        try {
            f = clazz.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-field", field, e.getMessage());
        }
        return f;
    }

    public static EntityLiving getHandle(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle();
    }

    public static float getSpeedFor(NPC npc) {
        EntityType entityType = npc.getBukkitEntity().getType();
        Float cached = MOVEMENT_SPEEDS.get(entityType);
        if (cached != null) {
            return cached.floatValue();
        }
        if (SPEED_FIELD == null) {
            MOVEMENT_SPEEDS.put(entityType, Float.valueOf(0.4f));
            return 0.4f;
        }
        try {
            float speed = SPEED_FIELD.getFloat(((CraftEntity)npc.getBukkitEntity()).getHandle());
            MOVEMENT_SPEEDS.put(entityType, Float.valueOf(speed));
            return speed;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return 0.4f;
        }
    }

    public static boolean inWater(LivingEntity entity) {
        EntityLiving mcEntity = NMS.getHandle(entity);
        return mcEntity.I() || mcEntity.J();
    }

    public static void loadPlugins() {
        ((CraftServer)Bukkit.getServer()).enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    public static void look(ControllerLook controllerLook, EntityLiving handle, EntityLiving target) {
        controllerLook.a((Entity)target, 10.0f, (float)handle.bp());
    }

    public static void look(LivingEntity bukkitEntity, float yaw, float pitch) {
        EntityLiving handle = NMS.getHandle(bukkitEntity);
        handle.yaw = yaw;
        NMS.setHeadYaw(handle, yaw);
        handle.pitch = pitch;
    }

    public static void registerEntityClass(Class<?> clazz) {
        if (ENTITY_CLASS_TO_INT.containsKey(clazz)) {
            return;
        }
        Class<?> search = clazz;
        while ((search = search.getSuperclass()) != null && Entity.class.isAssignableFrom(search)) {
            if (!ENTITY_CLASS_TO_INT.containsKey(search)) continue;
            int code = ENTITY_CLASS_TO_INT.get(search);
            ENTITY_INT_TO_CLASS.put(code, clazz);
            ENTITY_CLASS_TO_INT.put(clazz, code);
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass");
    }

    public static void removeFromServerPlayerList(Player player) {
        EntityPlayer handle = ((CraftPlayer)player).getHandle();
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(handle);
    }

    public static void sendPacket(Player player, Packet packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }

    public static void sendPacketsNearby(Location location, Collection<Packet> packets) {
        NMS.sendPacketsNearby(location, packets, 64.0);
    }

    public static void sendPacketsNearby(Location location, Collection<Packet> packets, double radius) {
        radius *= radius;
        org.bukkit.World world = location.getWorld();
        for (Player ply : Bukkit.getServer().getOnlinePlayers()) {
            if (ply == null || world != ply.getWorld() || location.distanceSquared(ply.getLocation(packetCacheLocation)) > radius) continue;
            for (Packet packet : packets) {
                NMS.sendPacket(ply, packet);
            }
        }
    }

    public static void sendPacketsNearby(Location location, Packet ... packets) {
        NMS.sendPacketsNearby(location, Arrays.asList(packets), 64.0);
    }

    public static void sendToOnline(Packet ... packets) {
        Validate.notNull((Object)packets, (String)"packets cannot be null");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !player.isOnline()) continue;
            for (Packet packet : packets) {
                NMS.sendPacket(player, packet);
            }
        }
    }

    public static void setDestination(LivingEntity bukkitEntity, double x, double y, double z, float speed) {
        ((CraftLivingEntity)bukkitEntity).getHandle().getControllerMove().a(x, y, z, speed);
    }

    public static void setHeadYaw(EntityLiving handle, float yaw) {
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        handle.az = yaw;
        handle.aA = yaw;
    }

    public static void setLandSpeedModifier(EntityLiving handle, float speed) {
        if (LAND_SPEED_MODIFIER_FIELD == null) {
            return;
        }
        try {
            LAND_SPEED_MODIFIER_FIELD.setFloat(handle, speed);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-erorrs.updating-land-modifier", e.getMessage());
        }
    }

    public static void setShouldJump(LivingEntity entity) {
        ControllerJump controller = NMS.getHandle(entity).getControllerJump();
        controller.a();
    }

    public static org.bukkit.entity.Entity spawnCustomEntity(org.bukkit.World world, Location at, Class<? extends Entity> clazz, EntityType type) {
        WorldServer handle = ((CraftWorld)world).getHandle();
        Entity entity = null;
        try {
            Constructor<?> constructor = NMS.getCustomEntityConstructor(clazz, type);
            entity = (Entity)constructor.newInstance(handle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.spawning-custom-entity", e.getMessage());
            return null;
        }
        handle.addEntity(entity);
        entity.setLocation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        return entity.getBukkitEntity();
    }

    public static void stopNetworkThreads(NetworkManager manager) {
        if (THREAD_STOPPER == null) {
            return;
        }
        try {
            THREAD_STOPPER.set(manager, false);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.stopping-network-threads", e.getMessage());
        }
    }

    public static void trySwim(LivingEntity handle) {
        NMS.trySwim(handle, 0.04f);
    }

    public static void trySwim(LivingEntity entity, float power) {
        EntityLiving handle = NMS.getHandle(entity);
        if (RANDOM.nextFloat() < 0.8f && NMS.inWater(entity)) {
            handle.motY += (double)power;
        }
    }

    public static void updateAI(EntityLiving entity) {
        NMS.updateSenses(entity);
        entity.getNavigation().e();
        entity.getControllerMove().c();
        entity.getControllerLook().a();
        entity.getControllerJump().b();
    }

    public static void updateNavigationWorld(LivingEntity entity, org.bukkit.World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        EntityLiving handle = ((CraftLivingEntity)entity).getHandle();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.set(handle.getNavigation(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", e.getMessage());
        }
    }

    public static void updatePathfindingRange(NPC npc, float pathfindingRange) {
        if (PATHFINDING_RANGE == null) {
            return;
        }
        Navigation navigation = ((CraftLivingEntity)npc.getBukkitEntity()).getHandle().getNavigation();
        try {
            PATHFINDING_RANGE.set(navigation, Float.valueOf(pathfindingRange));
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-pathfinding-range", e.getMessage());
        }
    }

    public static void updateSenses(EntityLiving entity) {
        entity.aA().a();
    }

    static {
        ENTITY_CONSTRUCTOR_CACHE = new WeakHashMap();
        MOVEMENT_SPEEDS = Maps.newEnumMap(EntityType.class);
        packetCacheLocation = new Location(null, 0.0, 0.0, 0.0);
        RANDOM = Util.getFastRandom();
        SLAB_MATERIALS = Sets.newHashSet();
        STAIR_MATERIALS = Sets.newHashSet();
        THREAD_STOPPER = NMS.getField(NetworkManager.class, "m");
        MOVEMENT_SPEEDS.put(EntityType.CHICKEN, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.COW, Float.valueOf(0.2f));
        MOVEMENT_SPEEDS.put(EntityType.CREEPER, Float.valueOf(0.3f));
        MOVEMENT_SPEEDS.put(EntityType.IRON_GOLEM, Float.valueOf(0.15f));
        MOVEMENT_SPEEDS.put(EntityType.MUSHROOM_COW, Float.valueOf(0.2f));
        MOVEMENT_SPEEDS.put(EntityType.OCELOT, Float.valueOf(0.23f));
        MOVEMENT_SPEEDS.put(EntityType.SHEEP, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.SNOWMAN, Float.valueOf(0.25f));
        MOVEMENT_SPEEDS.put(EntityType.PIG, Float.valueOf(0.27f));
        MOVEMENT_SPEEDS.put(EntityType.PLAYER, Float.valueOf(1.0f));
        MOVEMENT_SPEEDS.put(EntityType.VILLAGER, Float.valueOf(0.3f));
        LAND_SPEED_MODIFIER_FIELD = NMS.getField(EntityLiving.class, "bP");
        SPEED_FIELD = NMS.getField(EntityLiving.class, "bH");
        NAVIGATION_WORLD_FIELD = NMS.getField(Navigation.class, "b");
        PATHFINDING_RANGE = NMS.getField(Navigation.class, "e");
        GOAL_FIELD = NMS.getField(PathfinderGoalSelector.class, "a");
        try {
            Field field = NMS.getField(EntityTypes.class, "d");
            ENTITY_INT_TO_CLASS = (Map)field.get(null);
            field = NMS.getField(EntityTypes.class, "e");
            ENTITY_CLASS_TO_INT = (Map)field.get(null);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", e.getMessage());
        }
        for (Material material : Material.values()) {
            if (Step.class.isAssignableFrom(material.getData())) {
                SLAB_MATERIALS.add(material.getId());
                continue;
            }
            if (!Stairs.class.isAssignableFrom(material.getData())) continue;
            STAIR_MATERIALS.add(material.getId());
        }
    }
}

