/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree.expr;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.citizensnpcs.api.npc.NPC;

public class BehaviorSignals {
    private final Map<UUID, Multimap<String, SignalListener>> listeners = new ConcurrentHashMap<UUID, Multimap<String, SignalListener>>();

    public void clearListeners(NPC npc) {
        this.listeners.remove(npc.getUniqueId());
    }

    public void emit(NPC npc, String signal) {
        this.emitToNPC(npc.getUniqueId(), signal);
    }

    public void emitGlobal(String signal) {
        for (Multimap<String, SignalListener> bySignal : this.listeners.values()) {
            Collection signalListeners = bySignal.get((Object)signal);
            if (signalListeners == null) continue;
            for (SignalListener listener : signalListeners) {
                listener.signal();
            }
        }
    }

    public void emitToNPC(UUID npcId, String signal) {
        Multimap<String, SignalListener> npcListeners = this.listeners.get(npcId);
        if (npcListeners == null) {
            return;
        }
        Collection signalListeners = npcListeners.get((Object)signal);
        if (signalListeners != null) {
            for (SignalListener listener : signalListeners) {
                listener.signal();
            }
        }
    }

    public void listen(NPC npc, String signal, SignalListener listener) {
        this.listeners.computeIfAbsent(npc.getUniqueId(), k -> HashMultimap.create()).put((Object)signal, (Object)listener);
    }

    public void unlisten(NPC npc, String signal, SignalListener listener) {
        Multimap<String, SignalListener> bySignal = this.listeners.get(npc.getUniqueId());
        if (bySignal == null) {
            return;
        }
        Collection signals = bySignal.get((Object)signal);
        if (signals != null) {
            signals.remove(listener);
        }
        if (bySignal.isEmpty()) {
            this.listeners.remove(npc.getUniqueId());
        }
    }

    @FunctionalInterface
    public static interface SignalListener {
        public void signal();
    }
}

