/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCRemoveByCommandSenderEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.DataKey;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public interface NPC
extends Agent,
Cloneable {
    public void addRunnable(Runnable var1);

    public void addTrait(Class<? extends Trait> var1);

    public void addTrait(Trait var1);

    public NPC clone();

    public NPC copy();

    public MetadataStore data();

    default public boolean despawn() {
        return this.despawn(DespawnReason.PLUGIN);
    }

    public boolean despawn(DespawnReason var1);

    public void destroy();

    default public void destroy(CommandSender source) {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveByCommandSenderEvent(this, source));
        this.destroy();
    }

    public void faceLocation(Location var1);

    public BlockBreaker getBlockBreaker(Block var1, BlockBreaker.BlockBreakerConfiguration var2);

    public GoalController getDefaultGoalController();

    public SpeechController getDefaultSpeechController();

    public Entity getEntity();

    public String getFullName();

    public int getId();

    public Supplier<ItemStack> getItemProvider();

    public UUID getMinecraftUniqueId();

    public String getName();

    public Navigator getNavigator();

    public <T extends Trait> T getOrAddTrait(Class<T> var1);

    public NPCRegistry getOwningRegistry();

    public String getRawName();

    public Location getStoredLocation();

    @Deprecated
    public <T extends Trait> T getTrait(Class<T> var1);

    public <T extends Trait> T getTraitNullable(Class<T> var1);

    default public <T extends Trait> Optional<T> getTraitOptional(Class<T> trait) {
        return Optional.fromNullable(this.getTraitNullable(trait));
    }

    public Iterable<Trait> getTraits();

    public UUID getUniqueId();

    public boolean hasTrait(Class<? extends Trait> var1);

    default public boolean isFlyable() {
        return this.data().get(Metadata.FLYABLE, Boolean.valueOf(false));
    }

    default public boolean isHiddenFrom(Player player) {
        PlayerFilter filter = this.getTraitNullable(PlayerFilter.class);
        return filter != null ? filter.isHidden(player) : false;
    }

    default public boolean isProtected() {
        return this.data().get(Metadata.DEFAULT_PROTECTED, Boolean.valueOf(true));
    }

    default public boolean isPushableByFluids() {
        return this.data().get(Metadata.FLUID_PUSHABLE, Boolean.valueOf(!this.isProtected()));
    }

    public boolean isSpawned();

    public boolean isUpdating(NPCUpdate var1);

    public void load(DataKey var1);

    public void removeTrait(Class<? extends Trait> var1);

    public boolean requiresNameHologram();

    public void save(DataKey var1);

    public void scheduleUpdate(NPCUpdate var1);

    default public void setAlwaysUseNameHologram(boolean use) {
        this.data().setPersistent(Metadata.ALWAYS_USE_NAME_HOLOGRAM, (Object)use);
    }

    public void setBukkitEntityType(EntityType var1);

    default public void setFlyable(boolean flyable) {
        this.data().setPersistent(Metadata.FLYABLE, (Object)flyable);
    }

    public void setItemProvider(Supplier<ItemStack> var1);

    public void setMoveDestination(Location var1);

    public void setName(String var1);

    default public void setProtected(boolean isProtected) {
        this.data().setPersistent(Metadata.DEFAULT_PROTECTED, (Object)isProtected);
    }

    public void setSneaking(boolean var1);

    default public void setUseMinecraftAI(boolean use) {
        this.data().setPersistent(Metadata.USE_MINECRAFT_AI, (Object)use);
    }

    public boolean shouldRemoveFromPlayerList();

    public boolean shouldRemoveFromTabList();

    default public boolean spawn(Location location) {
        return this.spawn(location, SpawnReason.PLUGIN);
    }

    default public boolean spawn(Location at, Consumer<Entity> callback) {
        return this.spawn(at, SpawnReason.PLUGIN, callback);
    }

    default public boolean spawn(Location location, SpawnReason reason) {
        return this.spawn(location, reason, null);
    }

    public boolean spawn(Location var1, SpawnReason var2, Consumer<Entity> var3);

    public void teleport(Location var1, PlayerTeleportEvent.TeleportCause var2);

    default public boolean useMinecraftAI() {
        return this.data().get(Metadata.USE_MINECRAFT_AI, Boolean.valueOf(false));
    }

    public static enum Metadata {
        ACTIVATION_RANGE("activation-range", Integer.class),
        AGGRESSIVE("entity-aggressive", Boolean.class),
        ALWAYS_USE_NAME_HOLOGRAM("always-use-name-hologram", Boolean.class),
        AMBIENT_SOUND("ambient-sound", String.class),
        BOUNDING_BOX_FUNCTION("bounding-box-function", new TypeToken<Supplier<BoundingBox>>(){}, false),
        COLLIDABLE("collidable", Boolean.class),
        DAMAGE_OTHERS("damage-others", Boolean.class),
        DEATH_SOUND("death-sound", String.class),
        DEFAULT_PROTECTED("protected", Boolean.class),
        DISABLE_DEFAULT_STUCK_ACTION("disable-default-stuck-action", Boolean.class),
        DROPS_ITEMS("drops-items", Boolean.class),
        FLUID_PUSHABLE("fluid-pushable", Boolean.class),
        FLYABLE("flyable", Boolean.class),
        FORCE_PACKET_UPDATE("force-packet-update", Boolean.class),
        GLOWING("glowing", Boolean.class),
        HOLOGRAM_RENDERER("hologram-renderer", TypeToken.of(Object.class), false),
        HURT_SOUND("hurt-sound", String.class),
        ITEM_AMOUNT("item-type-amount", Integer.class),
        ITEM_DATA("item-type-data", Byte.class),
        ITEM_ID("item-type-id", String.class),
        JUMP_POWER_SUPPLIER("jump-power-supplier", new TypeToken<Function<NPC, Float>>(){}, false),
        KEEP_CHUNK_LOADED("keep-chunk-loaded", Boolean.class),
        KNOCKBACK("knockback", Boolean.class),
        LEASH_PROTECTED("protected-leash", Boolean.class),
        MINECART_OFFSET("minecart-item-offset", Integer.class),
        NAMEPLATE_VISIBLE("nameplate-visible", TypeToken.of(Boolean.class), false),
        NPC_SPAWNING_IN_PROGRESS("citizens-internal-spawning-npc", Boolean.class),
        PACKET_UPDATE_DELAY("packet-update-delay", Integer.class),
        PATHFINDER_OPEN_DOORS("pathfinder-open-doors", Boolean.class),
        PICKUP_ITEMS("pickup-items", Boolean.class),
        REMOVE_FROM_PLAYERLIST("removefromplayerlist", Boolean.class),
        REMOVE_FROM_TABLIST("removefromtablist", Boolean.class),
        RESET_PITCH_ON_TICK("reset-pitch-on-tick", Boolean.class),
        RESET_YAW_ON_SPAWN("reset-yaw-on-spawn", Boolean.class),
        RESPAWN_DELAY("respawn-delay", Integer.class),
        SCOREBOARD_FAKE_TEAM_NAME("fake-scoreboard-team-name", String.class),
        SHOULD_SAVE("should-save", Boolean.class),
        SILENT("silent-sounds", Boolean.class),
        SPAWN_NODAMAGE_TICKS("spawn-nodamage-ticks", Integer.class),
        SWIM("swim", Boolean.class),
        TEXT_DISPLAY_COMPONENT("text-display-component", TypeToken.of(Component.class), false),
        TRACKING_RANGE("tracking-distance", Integer.class),
        USE_MINECRAFT_AI("minecraft-ai", Boolean.class),
        USING_HELD_ITEM("using-held-item", Boolean.class),
        USING_OFFHAND_ITEM("using-offhand-item", Boolean.class),
        VILLAGER_BLOCK_TRADES("villager-trades", Boolean.class),
        WATER_SPEED_MODIFIER("water-speed-modifier", Float.class);

        private final String key;
        private final boolean strict;
        private final TypeToken<?> type;

        private Metadata(String key, Class<?> type) {
            this(key, TypeToken.of(type), true);
        }

        private Metadata(String key, TypeToken<?> type) {
            this(key, type, true);
        }

        private Metadata(String key, TypeToken<?> type, boolean strict) {
            this.key = key;
            this.type = type;
            this.strict = strict;
        }

        public boolean accepts(Class<? extends Object> clazz) {
            return !this.strict || this.type.isSupertypeOf(clazz);
        }

        public String getKey() {
            return this.key;
        }

        public TypeToken<?> getType() {
            return this.type;
        }

        public static Metadata byKey(String name) {
            for (Metadata v : Metadata.values()) {
                if (!v.key.equals(name)) continue;
                return v;
            }
            return null;
        }

        public static Metadata byName(String name) {
            try {
                return Metadata.valueOf(name);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }

    public static enum NPCUpdate {
        PACKET;

    }
}

