/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class Decorator
extends BehaviorGoalAdapter {
    private final Collection<Runnable> resetCallbacks;
    private final Collection<Runnable> runCallbacks;
    private final Collection<Predicate<Boolean>> shouldExecutePredicates;
    private final Collection<Function<BehaviorStatus, BehaviorStatus>> statusTransformers;
    private final Behavior wrapping;

    private Decorator(Behavior toWrap, Collection<Runnable> runCallbacks, Collection<Function<BehaviorStatus, BehaviorStatus>> statusTransformers, Collection<Predicate<Boolean>> shouldExecutePredicates, Collection<Runnable> resetCallbacks) {
        this.wrapping = toWrap;
        this.runCallbacks = runCallbacks;
        this.statusTransformers = statusTransformers;
        this.shouldExecutePredicates = shouldExecutePredicates;
        this.resetCallbacks = resetCallbacks;
    }

    @Override
    public void reset() {
        for (Runnable runnable : this.resetCallbacks) {
            runnable.run();
        }
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        for (Runnable runnable : this.runCallbacks) {
            runnable.run();
        }
        BehaviorStatus status = this.wrapping.run();
        for (Function<BehaviorStatus, BehaviorStatus> transformer : this.statusTransformers) {
            status = transformer.apply(status);
        }
        return status;
    }

    @Override
    public boolean shouldExecute() {
        boolean shouldExecute = this.wrapping.shouldExecute();
        for (Predicate<Boolean> transformer : this.shouldExecutePredicates) {
            shouldExecute = transformer.test(shouldExecute);
        }
        return shouldExecute;
    }

    public static Builder wrapping(Behavior toWrap) {
        return new Builder(toWrap);
    }

    public static class Builder {
        private Collection<Runnable> resetCallbacks = Collections.emptyList();
        private Collection<Runnable> runCallbacks = Collections.emptyList();
        private Collection<Predicate<Boolean>> shouldExecutePredicates = Collections.emptyList();
        private Collection<Function<BehaviorStatus, BehaviorStatus>> statusTransformers = Collections.emptyList();
        private final Behavior toWrap;

        private Builder(Behavior toWrap) {
            this.toWrap = toWrap;
        }

        public Decorator build() {
            return new Decorator(this.toWrap, this.runCallbacks, this.statusTransformers, this.shouldExecutePredicates, this.resetCallbacks);
        }

        public Builder withPreRunCallback(Runnable callback) {
            if (this.runCallbacks == Collections.EMPTY_LIST) {
                this.runCallbacks = new ArrayList<Runnable>();
            }
            this.runCallbacks.add(callback);
            return this;
        }

        public Builder withResetCallback(Runnable callback) {
            if (this.resetCallbacks == Collections.EMPTY_LIST) {
                this.resetCallbacks = new ArrayList<Runnable>();
            }
            this.resetCallbacks.add(callback);
            return this;
        }

        public Builder withShouldExecutePredicate(Predicate<Boolean> predicate) {
            if (this.shouldExecutePredicates == Collections.EMPTY_LIST) {
                this.shouldExecutePredicates = new ArrayList<Predicate<Boolean>>();
            }
            this.shouldExecutePredicates.add(predicate);
            return this;
        }

        public Builder withStatusTransformer(Function<BehaviorStatus, BehaviorStatus> transformer) {
            if (this.statusTransformers == Collections.EMPTY_LIST) {
                this.statusTransformers = new ArrayList<Function<BehaviorStatus, BehaviorStatus>>();
            }
            this.statusTransformers.add(transformer);
            return this;
        }
    }
}

