/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.List;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class JumpingExaminer
implements BlockExaminer.AdditionalNeighbourGenerator {
    private final int entityHeight;
    private final float speed;
    private static final double DRAG = 0.98;
    private static final int[] DX = new int[]{1, -1, 0, 0, 1, 1, -1, -1};
    private static final int[] DZ = new int[]{0, 0, 1, -1, 1, -1, 1, -1};
    private static final double GRAVITY = 0.08;
    private static final double[] INV_LEN = new double[]{1.0, 1.0, 1.0, 1.0, 0.7071067811865476, 0.7071067811865476, 0.7071067811865476, 0.7071067811865476};
    private static final double JUMP_VELOCITY = 0.42;
    private static final double XZ_DRAG = 0.91;

    public JumpingExaminer(double entityHeight, float speed) {
        this.entityHeight = (int)Math.ceil(entityHeight);
        this.speed = speed;
    }

    @Override
    public void addNeighbours(BlockSource source, PathPoint point, List<PathPoint> neighbours) {
        Vector base = point.getVector();
        int minY = base.getBlockY() - 3;
        block0: for (int i = 0; i < 8; ++i) {
            double vx = (double)DX[i] * INV_LEN[i] * (double)this.speed;
            double vy = 0.42;
            double vz = (double)DZ[i] * INV_LEN[i] * (double)this.speed;
            double x = (double)base.getBlockX() + 0.5;
            double y = base.getBlockY();
            double z = (double)base.getBlockZ() + 0.5;
            int px = base.getBlockX();
            int py = base.getBlockY();
            int pz = base.getBlockZ();
            block1: for (int tick = 0; tick < 60; ++tick) {
                x += vx;
                y += vy;
                z += vz;
                vx *= 0.91;
                vy = (vy - 0.08) * 0.98;
                vz *= 0.91;
                int bx = JumpingExaminer.floor(x);
                int by = JumpingExaminer.floor(y);
                int bz = JumpingExaminer.floor(z);
                if (bx == px && by == py && bz == pz) continue;
                if (by < minY || !source.isYWithinBounds(by)) continue block0;
                int cx = px;
                int cy = py;
                int cz = pz;
                while (cx != bx || cy != by || cz != bz) {
                    if (cx != bx) {
                        cx += Integer.compare(bx, cx);
                    }
                    if (cy != by) {
                        cy += Integer.compare(by, cy);
                    }
                    if (cz != bz) {
                        cz += Integer.compare(bz, cz);
                    }
                    if (cy < minY || !source.isYWithinBounds(cy) || !this.isClearColumn(source, cx, cy, cz)) continue block1;
                    if (!(vy <= 0.0) || !source.isYWithinBounds(cy - 1) || !MinecraftBlockExaminer.canStandOn(source.getMaterialAt(cx, cy - 1, cz))) continue;
                    point.addCallback(new JumpCallback());
                    neighbours.add(point.createAtOffset(new Vector(cx, cy, cz), 1.0f));
                    cx = bx;
                    cy = by;
                    cz = bz;
                    continue block1;
                }
                if (!this.isClearColumn(source, bx, by, bz) || by < minY) continue block0;
                px = bx;
                py = by;
                pz = bz;
            }
        }
    }

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        return BlockExaminer.StandableState.IGNORE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    private boolean isClearColumn(BlockSource source, int x, int feetY, int z) {
        for (int h = 0; h < this.entityHeight; ++h) {
            int y = feetY + h;
            if (MinecraftBlockExaminer.canStandIn(source.getMaterialAt(x, y, z))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        return BlockExaminer.PassableState.IGNORE;
    }

    private static int floor(double v) {
        int i = (int)v;
        return v < (double)i ? i - 1 : i;
    }

    public class JumpCallback
    implements PathPoint.PathCallback {
        @Override
        public void onReached(NPC npc, Block point) {
            npc.getEntity().setVelocity(npc.getEntity().getVelocity().add(new Vector(0.0, 0.42, 0.0)));
        }

        @Override
        public void run(NPC npc, Block point, List<Block> path, int index) {
        }
    }
}

