/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.jnbt;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import net.citizensnpcs.api.jnbt.Tag;

public final class CompoundTag
extends Tag {
    private final Map<String, Tag> value;

    public CompoundTag(String name, Map<String, Tag> value) {
        super(name);
        this.value = Collections.unmodifiableMap(value);
    }

    public CompoundTag(String name) {
        super(name);
        this.value = Maps.newHashMap();
    }

    @Override
    public Map<String, Tag> getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_Compound" + append + ": " + this.value.size() + " entries\r\n{\r\n");
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            bldr.append("   " + entry.getValue().toString().replaceAll("\r\n", "\r\n   ") + "\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }
}

