/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.function.Consumer;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class Callback
extends BehaviorGoalAdapter {
    private final Consumer<BehaviorStatus> cb;
    private final Behavior wrapping;

    private Callback(Behavior wrapping, Consumer<BehaviorStatus> cb) {
        this.wrapping = wrapping;
        this.cb = cb;
    }

    @Override
    public void reset() {
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus status = this.wrapping.run();
        switch (status) {
            case FAILURE: 
            case SUCCESS: 
            case RESET_AND_REMOVE: {
                this.cb.accept(status);
            }
        }
        return status;
    }

    @Override
    public boolean shouldExecute() {
        return this.wrapping.shouldExecute();
    }

    public static Callback callback(Behavior wrapping, Consumer<BehaviorStatus> cb) {
        return new Callback(wrapping, cb);
    }
}

