/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.event;

import java.util.Objects;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class NPCMoveEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final NPC npc;
    private Location from;
    private Location to;
    private boolean cancelled;

    public NPCMoveEvent(NPC npc, Location from, Location to) {
        this.npc = npc;
        this.from = from;
        this.to = to;
    }

    public NPC getNPC() {
        return this.npc;
    }

    public Location getFrom() {
        return this.from;
    }

    public Location getTo() {
        return this.to;
    }

    public void setFrom(Location from) {
        Objects.requireNonNull(from, "from cannot be null");
        Objects.requireNonNull(from.getWorld(), "from.getWorld() cannot be null");
        this.from = from;
    }

    public void setTo(Location to) {
        Objects.requireNonNull(to, "to cannot be null");
        Objects.requireNonNull(to.getWorld(), "to.getWorld() cannot be null");
        this.to = to;
    }

    public boolean hasChangedPosition() {
        return this.hasExplicitlyChangedPosition() || !this.from.getWorld().equals((Object)this.to.getWorld());
    }

    public boolean hasExplicitlyChangedPosition() {
        return this.from.getX() != this.to.getX() || this.from.getY() != this.to.getY() || this.from.getZ() != this.to.getZ();
    }

    public boolean hasChangedBlock() {
        return this.hasExplicitlyChangedBlock() || !this.from.getWorld().equals((Object)this.to.getWorld());
    }

    public boolean hasExplicitlyChangedBlock() {
        return this.from.getBlockX() != this.to.getBlockX() || this.from.getBlockY() != this.to.getBlockY() || this.from.getBlockZ() != this.to.getBlockZ();
    }

    public boolean hasChangedRotation() {
        return this.from.getPitch() != this.to.getPitch() || this.from.getYaw() != this.to.getYaw();
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean b) {
        this.cancelled = b;
    }

    public String toString() {
        return "NPCMoveEvent{npc=" + this.npc + ", from=" + this.from + ", to=" + this.to + ", cancelled=" + this.cancelled + '}';
    }
}

