/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import org.apache.commons.dbutils.DbUtils;

public class DatabaseStorage
implements Storage {
    private final Map<String, Table> tables = Maps.newHashMap();
    private final String url;
    private final String username;
    private final String password;
    private static final Pattern INTEGER = Pattern.compile("([\\+-]?\\d+)([eE][\\+-]?\\d+)?");

    public DatabaseStorage(String driver, String url, String username, String password) throws SQLException {
        this.url = url = "jdbc:" + url;
        this.username = username;
        this.password = password;
        DatabaseType.match(driver).load();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKey(Table from, Table to) {
        String fk = "fk_" + to.name;
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("ALTER TABLE `" + from.name + "` ADD FOREIGN KEY (`" + fk + "`) REFERENCES `" + to.name + "` (`" + to.name + "_id" + "`)");
            stmt.execute();
            from.foreignKeys.put(fk, new ForeignKey(to, fk));
            DbUtils.closeQuietly((Connection)conn, (Statement)stmt, null);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)conn, stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table createTable(String name, int type) {
        String pk = name + "_id";
        String pkType = "";
        switch (type) {
            case 4: {
                pkType = "INTEGER NOT NULL";
                break;
            }
            case 12: {
                pkType = "varchar(255) NOT NULL";
                break;
            }
            default: {
                throw new IllegalArgumentException("type not supported");
            }
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        Table created = null;
        try {
            stmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS `" + name + "` (`" + pk + "` " + pkType + " PRIMARY KEY (`" + pk + "`))");
            stmt.execute();
            created = new Table().setName(name).setPrimaryKey(pk).setPrimaryKeyType(type);
            this.tables.put(name, created);
            DbUtils.closeQuietly((Connection)conn, (Statement)stmt, null);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)conn, stmt, null);
        }
        return created;
    }

    private Connection getConnection() {
        try {
            return this.username.isEmpty() && this.password.isEmpty() ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public DataKey getKey(String root) {
        String[] split = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)root), String.class);
        if (split[0].isEmpty()) {
            return new DatabaseKey();
        }
        DataKey table = new DatabaseKey(split[0]);
        if (split.length == 1) {
            return table;
        }
        for (int i = 1; i < split.length; ++i) {
            table = ((DataKey)table).getRelative(split[i]);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        Connection conn = this.getConnection();
        try {
            ResultSet rs = conn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                this.tables.put(rs.getString("TABLE_NAME"), new Table());
            }
            rs.close();
            for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
                entry.getValue().name = entry.getKey();
                rs = conn.getMetaData().getColumns(null, null, entry.getKey(), null);
                while (rs.next()) {
                    entry.getValue().columns.add(rs.getString("COLUMN_NAME"));
                    rs.getMetaData().getColumnType(0);
                }
                rs.close();
                rs = conn.getMetaData().getPrimaryKeys(null, null, entry.getKey());
                while (rs.next()) {
                    entry.getValue().primaryKey = rs.getString("PK_NAME");
                    entry.getValue().setPrimaryKeyType(rs.getMetaData().getColumnType(4));
                }
                rs.close();
                rs = conn.getMetaData().getImportedKeys(null, null, entry.getKey());
                while (rs.next()) {
                    ForeignKey key = new ForeignKey(this.tables.get(rs.getString("FKTABLE_NAME")), rs.getString("PKCOLUMN_NAME"));
                    entry.getValue().foreignKeys.put(key.localColumn, key);
                }
                rs.close();
                System.out.println(entry.getValue());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    @Override
    public void save() {
    }

    private class CreateRelation
    implements Runnable {
        private final Table from;
        private final String primary;
        private final ForeignKey mapping;

        CreateRelation(DatabaseKey update, ForeignKey mapping) {
            this.from = update.table;
            this.primary = update.currentKey;
            this.mapping = mapping;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection conn = DatabaseStorage.this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement("INSERT INTO ? () VALUES ()", 1);
                stmt.executeUpdate();
                rs = stmt.getGeneratedKeys();
                rs.next();
                String generated = rs.getString(this.mapping.foreignTable.primaryKey);
                DbUtils.closeQuietly(null, (Statement)stmt, (ResultSet)rs);
                stmt = conn.prepareStatement("UPDATE `" + this.from.name + "` SET `" + this.mapping.localColumn + "`=" + generated + " WHERE `" + this.from.primaryKey + "`= ?");
                stmt.setString(1, this.primary);
                stmt.executeUpdate();
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, rs);
            }
        }
    }

    private static class Table {
        final List<String> columns = Lists.newArrayList();
        final Map<String, ForeignKey> foreignKeys = Maps.newHashMap();
        String name;
        String primaryKey;
        int primaryKeyType;

        private Table() {
        }

        public Table setName(String tableName) {
            this.name = tableName;
            return this;
        }

        public Table setPrimaryKey(String pk) {
            this.primaryKey = pk;
            return this;
        }

        public Table setPrimaryKeyType(int type) {
            this.primaryKeyType = type;
            return this;
        }

        public String toString() {
            return "Table [primaryKey=" + this.primaryKey + ", foreignKeys=" + this.foreignKeys + ", columns=" + this.columns + "]";
        }
    }

    private static class ForeignKey {
        final Table foreignTable;
        final String localColumn;

        ForeignKey(Table foreign, String from) {
            this.foreignTable = foreign;
            this.localColumn = from;
        }
    }

    public static enum DatabaseType {
        H2("org.h2.Driver"),
        MYSQL("com.mysql.jdbc.Driver"),
        POSTGRE("org.postgresql.Driver"),
        SQLITE("org.sqlite.JDBC");

        private final String driver;
        private boolean loaded = false;

        private DatabaseType(String driver) {
            this.driver = driver;
        }

        public boolean load() {
            if (this.loaded) {
                return true;
            }
            if (DbUtils.loadDriver((String)this.driver)) {
                this.loaded = true;
            }
            return this.loaded;
        }

        public static DatabaseType match(String driver) {
            for (DatabaseType type : DatabaseType.values()) {
                if (!type.name().toLowerCase().contains(driver)) continue;
                return type;
            }
            return null;
        }
    }

    public class DatabaseKey
    extends DataKey {
        private String currentKey;
        private Table table;
        private String tableName;

        public DatabaseKey(String _table) {
            if (_table == null) {
                throw new IllegalArgumentException("table cannot be null");
            }
            if (_table.charAt(_table.length()) == 's') {
                _table = _table.substring(0, _table.length() - 1);
            }
            this.table = (Table)DatabaseStorage.this.tables.get(_table);
            this.tableName = _table;
        }

        public DatabaseKey(Table table, String currentKey) {
            if (table == null || currentKey == null) {
                throw new IllegalArgumentException("arguments cannot be null");
            }
            this.table = table;
            this.currentKey = currentKey;
        }

        public DatabaseKey() {
        }

        @Override
        public void copy(String to) {
        }

        @Override
        public boolean getBoolean(String key) {
            return false;
        }

        @Override
        public double getDouble(String key) {
            return 0.0;
        }

        @Override
        public int getInt(String key) {
            return 0;
        }

        @Override
        public List<DataKey> getIntegerSubKeys() {
            return null;
        }

        @Override
        public long getLong(String key) {
            return 0L;
        }

        @Override
        public Object getRaw(String key) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DatabaseKey getRelative(String relative) {
            if (relative.isEmpty()) {
                return this;
            }
            String[] split = relative.split("\\.");
            if (this.table == null) {
                String primary = null;
                if (this.tableName == null) {
                    this.tableName = split[0];
                    if ((split = Arrays.copyOfRange(split, 1, split.length)).length > 1) {
                        primary = split[1];
                        split = Arrays.copyOfRange(split, 1, split.length);
                    }
                } else {
                    primary = split[0];
                    split = Arrays.copyOfRange(split, 1, split.length);
                }
                if (primary != null) {
                    this.table = DatabaseStorage.this.createTable(this.tableName, INTEGER.matcher(primary).matches() ? 4 : 12);
                    this.currentKey = primary;
                }
            }
            String rel = split[0];
            if (!DatabaseStorage.this.tables.containsKey(rel)) {
                DatabaseStorage.this.createTable(rel, 4);
            }
            Table foreign = (Table)DatabaseStorage.this.tables.get(rel);
            if (!this.table.foreignKeys.containsKey("fk_" + foreign.name)) {
                DatabaseStorage.this.createForeignKey(this.table, foreign);
            }
            ForeignKey mapping = this.table.foreignKeys.get("fk_" + foreign.name);
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement("SELECT `" + mapping.foreignTable.primaryKey + "` FROM `" + mapping.foreignTable.name + "` INNER JOIN `" + this.table.name + "` ON `" + mapping.foreignTable.primaryKey + "`=`" + mapping.localColumn + "`");
                ResultSet rs = stmt.executeQuery();
                DatabaseKey databaseKey = new DatabaseKey(mapping.foreignTable, rs.getString(mapping.foreignTable.primaryKey));
                return databaseKey;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly((Connection)conn);
            }
            return null;
        }

        @Override
        public String getString(String key) {
            return null;
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            return null;
        }

        @Override
        public boolean keyExists(String key) {
            return false;
        }

        @Override
        public String name() {
            return this.currentKey != null ? this.currentKey : this.table.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeKey(String key) {
            Connection conn = DatabaseStorage.this.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement("DELETE FROM `" + this.table.name + "` WHERE `" + this.table.primaryKey + "` = ?");
                stmt.setString(1, key);
                stmt.executeUpdate();
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly((Connection)conn, stmt, null);
            }
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setDouble(String key, double value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setInt(String key, int value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setLong(String key, long value) {
            this.setPrimitive(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPrimitive(String key, Object value) {
            this.runActions();
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)key), String.class);
            String column = key;
            String primaryReferenceKey = this.currentKey;
            Table from = this.table;
            if (parts.length > 1) {
                DatabaseKey traverse = new DatabaseKey(this.table, this.currentKey);
                for (int i = 0; i < parts.length - 1; ++i) {
                    traverse = traverse.getRelative(parts[i]);
                }
                traverse.runActions();
                from = traverse.table;
                primaryReferenceKey = traverse.currentKey;
                column = parts[parts.length - 1];
            }
            Connection conn = DatabaseStorage.this.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement("UPDATE `" + from.name + "` SET `" + column + "`=" + value + " WHERE `" + from.primaryKey + "` =" + primaryReferenceKey);
                stmt.executeUpdate();
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, null);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly((Connection)conn, stmt, null);
            }
        }

        private void runActions() {
        }

        @Override
        public void setRaw(String key, Object value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setString(String key, String value) {
            this.setPrimitive(key, value);
        }
    }
}

