/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.objects;

import com.denizenscript.clientizen.mixin.ClientWorldAccessor;
import com.denizenscript.clientizen.objects.EntityTag;
import com.denizenscript.clientizen.objects.MaterialTag;
import com.denizenscript.clientizen.util.Utilities;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.VectorObject;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_638;
import org.joml.Math;

public class LocationTag
implements ObjectTag,
VectorObject {
    double x;
    double y;
    double z;
    final float yaw;
    final float pitch;
    final String world;
    public static final ObjectTagProcessor<LocationTag> tagProcessor = new ObjectTagProcessor();
    private String prefix = "Location";

    public LocationTag(double x, double y, double z, float yaw, float pitch, String world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = LocationTag.normalizeYaw(yaw);
        this.pitch = pitch;
        this.world = world;
    }

    public LocationTag(double x, double y, double z, float yaw, float pitch) {
        this(x, y, z, yaw, pitch, null);
    }

    public LocationTag(double x, double y, double z, String world) {
        this(x, y, z, 0.0f, 0.0f, world);
    }

    public LocationTag(double x, double y, double z) {
        this(x, y, z, null);
    }

    public LocationTag(class_2374 position) {
        this(position.method_10216(), position.method_10214(), position.method_10215());
    }

    public LocationTag(class_2374 position, float yaw, float pitch) {
        this(position.method_10216(), position.method_10214(), position.method_10215(), yaw, pitch);
    }

    public LocationTag(class_2382 intVector) {
        this(intVector.method_10263(), (double)intVector.method_10264(), (double)intVector.method_10260());
    }

    public LocationTag(LocationTag toCopy) {
        this.x = toCopy.x;
        this.y = toCopy.y;
        this.z = toCopy.z;
        this.yaw = toCopy.yaw;
        this.pitch = toCopy.pitch;
        this.world = toCopy.world;
    }

    @Fetchable(value="l")
    public static LocationTag valueOf(String string, TagContext context) {
        List split;
        int size;
        if (string == null) {
            return null;
        }
        if (string.startsWith("l@")) {
            string = string.substring("l@".length());
        }
        if ((size = (split = CoreUtilities.split((String)string, (char)',')).size()) < 2 || size > 6) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf LocationTag returning null, not formatted as a LocationTag: " + string));
            }
            return null;
        }
        try {
            double x = Double.parseDouble((String)split.get(0));
            double y = Double.parseDouble((String)split.get(1));
            double z = 0.0;
            float yaw = 0.0f;
            float pitch = 0.0f;
            String world = null;
            if (size > 2) {
                z = Double.parseDouble((String)split.get(2));
            }
            if (size == 5 || size == 6) {
                pitch = Float.parseFloat((String)split.get(3));
                yaw = Float.parseFloat((String)split.get(4));
            }
            if ((size == 4 || size == 6) && (world = (String)split.get(size - 1)).startsWith("w@")) {
                world = world.substring("w@".length());
            }
            return new LocationTag(x, y, z, yaw, pitch, world);
        }
        catch (Exception e) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf LocationTag returning null: " + string + " (internal exception:" + e.getMessage() + ")"));
            }
            return null;
        }
    }

    public static boolean matches(String string) {
        if (string.startsWith("l@")) {
            return true;
        }
        return LocationTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public static class_638 getWorld() {
        return Objects.requireNonNull(class_310.method_1551().field_1687, "Missing world! this should never happen, please report to developers.");
    }

    public static void register() {
        VectorObject.register(LocationTag.class, tagProcessor);
        tagProcessor.registerStaticTag(ElementTag.class, "yaw", (attribute, object) -> new ElementTag(LocationTag.normalizeYaw(object.yaw)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "raw_yaw", (attribute, object) -> new ElementTag(object.yaw), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "pitch", (attribute, object) -> new ElementTag(object.pitch), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "world", (attribute, object) -> object.world != null ? new ElementTag(object.world, true) : null, new String[0]);
        tagProcessor.registerStaticTag(LocationTag.class, "block", (attribute, object) -> new LocationTag(object.getBlockX(), object.getBlockY(), object.getBlockZ(), object.world), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "round_down", (attribute, object) -> new LocationTag(Math.floor((double)object.x), Math.floor((double)object.y), Math.floor((double)object.z), Math.floor((float)object.yaw), Math.floor((float)object.pitch), object.world), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "above", (attribute, object) -> object.duplicate().add(0.0, attribute.hasParam() ? attribute.getDoubleParam() : 1.0, 0.0), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "below", (attribute, object) -> object.duplicate().subtract(0.0, attribute.hasParam() ? attribute.getDoubleParam() : 1.0, 0.0), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "forward", (attribute, object) -> {
            class_243 vector = object.getDirection().method_1021(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return object.duplicate().add(vector);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "backward", (attribute, object) -> {
            class_243 vector = object.getDirection().method_1021(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return object.duplicate().subtract(vector);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "left", (attribute, object) -> {
            class_243 vector = class_243.method_1030((float)0.0f, (float)object.yaw).method_1024(1.5707964f).method_1021(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return object.duplicate().add(vector);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "right", (attribute, object) -> {
            class_243 vector = class_243.method_1030((float)0.0f, (float)object.yaw).method_1024(1.5707964f).method_1021(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return object.duplicate().subtract(vector);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "up", (attribute, object) -> {
            class_243 vector = class_243.method_1030((float)(object.pitch - 90.0f), (float)object.yaw).method_1021(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return object.duplicate().add(vector);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "down", (attribute, object) -> {
            class_243 vector = class_243.method_1030((float)(object.pitch - 90.0f), (float)object.yaw).method_1021(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return object.duplicate().subtract(vector);
        }, new String[0]);
        tagProcessor.registerTag(MaterialTag.class, "material", (attribute, object) -> object.isChunkLoaded() ? new MaterialTag(LocationTag.getWorld().method_8320(object.getBlockPos())) : null, new String[0]);
        tagProcessor.registerTag(ListTag.class, MapTag.class, "find_entities", (attribute, object, param) -> {
            ElementTag rangeElement = (ElementTag)param.getRequiredObjectAs("within", ElementTag.class, attribute);
            if (rangeElement == null) {
                return null;
            }
            if (!rangeElement.isInt()) {
                attribute.echoError("Invalid 'within' value '" + String.valueOf(rangeElement) + "' specified: must be a number.");
                return null;
            }
            int range = rangeElement.asInt();
            if (range < 0) {
                attribute.echoError("Invalid 'within' value '" + String.valueOf(rangeElement) + "': cannot be lower than 0.");
                return null;
            }
            ElementTag matcherElement = param.getElement("match");
            String matcher = matcherElement != null ? matcherElement.asString() : null;
            class_243 originPos = object.getPosVector();
            ListTag entities = new ListTag();
            int doubleRange = range * 2;
            ((ClientWorldAccessor)LocationTag.getWorld()).invokeGetEntities().method_31807(class_238.method_30048((class_243)originPos, (double)doubleRange, (double)doubleRange, (double)doubleRange), entity -> {
                if (!Utilities.checkLocationWithBoundingBox(originPos, entity, range)) {
                    return;
                }
                EntityTag entityTag = new EntityTag((class_1297)entity);
                if (matcher == null || entityTag.advancedMatches(matcher, attribute.context)) {
                    entities.addObject((ObjectTag)entityTag);
                }
            });
            entities.objectForms.sort((firstEnt, secondEnt) -> object.compare(((EntityTag)firstEnt).getEntity().method_73189(), ((EntityTag)secondEnt).getEntity().method_73189()));
            return entities;
        }, new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public LocationTag duplicate() {
        return new LocationTag(this);
    }

    public String identify(String separator) {
        String output = CoreUtilities.doubleToString((double)this.x) + separator + CoreUtilities.doubleToString((double)this.y) + separator + CoreUtilities.doubleToString((double)this.z);
        if (this.yaw != 0.0f || this.pitch != 0.0f) {
            output = output + separator + CoreUtilities.floatToCleanString((float)this.pitch) + separator + CoreUtilities.floatToCleanString((float)this.yaw);
        }
        if (this.world != null) {
            output = output + separator + this.world;
        }
        return output;
    }

    public String identify() {
        return "l@" + this.identify(",");
    }

    public String debuggable() {
        return "<LG>l@<Y>" + this.identify("<LG>,<Y>");
    }

    public String identifySimple() {
        return "l@" + this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ() + (String)(this.world != null ? "," + this.world : "");
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return false;
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public boolean isChunkLoaded() {
        class_638 world = class_310.method_1551().field_1687;
        return world != null && world.method_8393(class_4076.method_32204((double)this.getX()), class_4076.method_32204((double)this.getZ()));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public LocationTag add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public LocationTag add(class_243 toAdd) {
        return this.add(toAdd.method_10216(), toAdd.method_10214(), toAdd.method_10215());
    }

    public LocationTag subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public LocationTag subtract(class_243 toSub) {
        return this.subtract(toSub.method_10216(), toSub.method_10214(), toSub.method_10215());
    }

    public int getBlockX() {
        return class_3532.method_15357((double)this.getX());
    }

    public int getBlockY() {
        return class_3532.method_15357((double)this.getY());
    }

    public int getBlockZ() {
        return class_3532.method_15357((double)this.getZ());
    }

    public class_2338 getBlockPos() {
        return class_2338.method_49637((double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public class_243 getDirection() {
        return class_243.method_1030((float)this.pitch, (float)this.yaw);
    }

    public class_243 getPosVector() {
        return new class_243(this.getX(), this.getY(), this.getZ());
    }

    public int compare(class_243 pos1, class_243 pos2) {
        if (pos1 == pos2) {
            return 0;
        }
        if (pos1 == null) {
            return 1;
        }
        if (pos2 == null) {
            return -1;
        }
        if (pos1.equals((Object)pos2)) {
            return 0;
        }
        return Double.compare(pos1.method_1028(this.getX(), this.getY(), this.getZ()), pos2.method_1028(this.getX(), this.getY(), this.getZ()));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

