/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.containers.gui;

import com.denizenscript.clientizen.objects.ItemTag;
import com.denizenscript.clientizen.scripts.containers.gui.elements.BoxPanelElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.ButtonElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.DynamicLabelElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.GridPanelElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.ItemElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.LabelElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.LabeledSliderElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.PlainPanelElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.ProgressBarElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.ScrollPanelElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.SliderElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.SpriteElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.TabPanelElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.TextElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.TextFieldElement;
import com.denizenscript.clientizen.scripts.containers.gui.elements.ToggleButtonElement;
import com.denizenscript.clientizen.tags.ClientizenTagContext;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;

public class GuiScriptContainer
extends ScriptContainer {
    private static final Map<String, GuiElementParser> guiElementParsers = new HashMap<String, GuiElementParser>();
    public static ContextStringSupplier currentContextSupplier;

    public static void registerGuiElement(String typeName, GuiElementParser parser) {
        if (guiElementParsers.putIfAbsent(typeName, parser) != null) {
            throw new InvalidArgumentsRuntimeException("A GUI element with type '" + typeName + "' is already registered.");
        }
    }

    public GuiScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public static String getTaggedString(YamlConfiguration config, String path, TagContext context) {
        return GuiScriptContainer.getTaggedString(config, path, null, context);
    }

    public static String getTaggedString(YamlConfiguration config, String path, String defaultValue, TagContext context) {
        String str = config.getString(path);
        return str != null ? TagManager.tag((String)str, (TagContext)context) : defaultValue;
    }

    public static Integer getTaggedInt(YamlConfiguration config, String path, TagContext context) {
        return GuiScriptContainer.getTaggedInt(config, path, null, context);
    }

    public static Integer getTaggedInt(YamlConfiguration config, String path, Integer defaultValue, TagContext context) {
        String str = GuiScriptContainer.getTaggedString(config, path, context);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.echoError((String)("Invalid integer number specified under '" + path + "': " + str + "."));
            return null;
        }
    }

    public static Float getTaggedFloat(YamlConfiguration config, String path, TagContext context) {
        return GuiScriptContainer.getTaggedFloat(config, path, null, context);
    }

    public static Float getTaggedFloat(YamlConfiguration config, String path, Float defaultValue, TagContext context) {
        String str = GuiScriptContainer.getTaggedString(config, path, context);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException numberFormatException) {
            Debug.echoError((String)("Invalid number specified under '" + path + "': " + str + "."));
            return null;
        }
    }

    public static Boolean getTaggedBoolean(YamlConfiguration config, String path, TagContext context) {
        String str = GuiScriptContainer.getTaggedString(config, path, context);
        if (str == null) {
            return null;
        }
        boolean equalsTrue = CoreUtilities.equalsIgnoreCase((String)str, (String)"true");
        if (!equalsTrue && !CoreUtilities.equalsIgnoreCase((String)str, (String)"false")) {
            Debug.echoError((String)("Invalid boolean '" + str + "' specified under '" + path + "': must be either 'true' or 'false'."));
            return null;
        }
        return equalsTrue;
    }

    public static <T extends ObjectTag> T getTaggedObject(Class<T> objectType, YamlConfiguration config, String path, TagContext context) {
        String str = config.getString(path);
        if (str == null) {
            return null;
        }
        ObjectTag converted = TagManager.tagObject((String)str, (TagContext)context).asType(objectType, context);
        if (converted == null) {
            Debug.echoError((String)("Invalid " + DebugInternals.getClassNameOpti(objectType) + " specified under '" + path + "': " + str + "."));
            return null;
        }
        return (T)converted;
    }

    public static <T extends ObjectTag> List<T> getTaggedObjectList(Class<T> objectType, YamlConfiguration config, String path, TagContext context) {
        Object object = config.get(path);
        if (object == null) {
            return null;
        }
        ListTag list = (ListTag)CoreUtilities.objectToTagForm((Object)object, (TagContext)context, (boolean)true, (boolean)true, (boolean)true).asType(ListTag.class, context);
        if (list == null) {
            return null;
        }
        return list.filter(objectType, context);
    }

    public static List<String> getTaggedStringList(YamlConfiguration config, String path, TagContext context) {
        Object object = config.get(path);
        if (object == null) {
            return null;
        }
        return (List)CoreUtilities.objectToTagForm((Object)object, (TagContext)context, (boolean)true, (boolean)true, (boolean)true).asType(ListTag.class, context);
    }

    public static <T extends Enum<T>> T getTaggedEnum(Class<T> enumClass, YamlConfiguration config, String path, TagContext context) {
        return GuiScriptContainer.getTaggedEnum(enumClass, null, config, path, context);
    }

    public static <T extends Enum<T>> T getTaggedEnum(Class<T> enumClass, T defaultValue, YamlConfiguration config, String path, TagContext context) {
        String str = GuiScriptContainer.getTaggedString(config, path, context);
        if (str == null) {
            return defaultValue;
        }
        Enum converted = (Enum)ElementTag.asEnum(enumClass, (String)str);
        if (converted == null) {
            Debug.echoError((String)("Invalid '" + path + "' value '" + str + "': must be one of " + Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", ")) + "."));
            return null;
        }
        return (T)converted;
    }

    public static String getSubPath(String path, String subKey) {
        return path.isEmpty() ? subKey : path + "." + subKey;
    }

    public static String getWidgetId(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    public static String getDebugPath(String path) {
        return path.isEmpty() ? "(root element)" : path;
    }

    public WPanel createGUIRoot() {
        currentContextSupplier = new ContextStringSupplier();
        Debug.pushErrorContext((Object)currentContextSupplier);
        WWidget created = this.createGUI();
        Debug.popErrorContext();
        currentContextSupplier = null;
        if (created == null) {
            return null;
        }
        if (!(created instanceof WPanel)) {
            Debug.echoError((String)("Invalid GUI script '" + this.getOriginalName() + "': must have a panel as the root element."));
            return null;
        }
        WPanel rootPanel = (WPanel)created;
        return rootPanel;
    }

    public WWidget createGUI() {
        return this.parseGUIWidget(this.getContents(), "", "", new ClientizenTagContext(this));
    }

    public WWidget parseGUIWidget(YamlConfiguration config, String key, String pathToWidgetConfig, TagContext context) {
        if (config == null) {
            return null;
        }
        String pathToWidget = key.isEmpty() ? pathToWidgetConfig : pathToWidgetConfig + "." + key;
        String debugPathToWidget = GuiScriptContainer.getDebugPath(pathToWidget);
        YamlConfiguration widgetConfig = config.getConfigurationSection(key);
        if (widgetConfig == null) {
            String guiScriptName = config.getString(key);
            GuiScriptContainer guiScript = (GuiScriptContainer)ScriptRegistry.getScriptContainerAs((String)guiScriptName, GuiScriptContainer.class);
            if (guiScript == null) {
                Debug.echoError((String)("Invalid GUI script container specified for GUI element '" + debugPathToWidget + "': " + guiScriptName + "."));
                return null;
            }
            return guiScript.createGUI();
        }
        String uiType = widgetConfig.getString("ui_type");
        if (uiType == null) {
            String previousContext = currentContextSupplier.set(null);
            Debug.echoError((ScriptContainer)this, (String)("Invalid GUI element '" + debugPathToWidget + "' is missing a type!"));
            currentContextSupplier.set(previousContext);
            return null;
        }
        String previousContext = currentContextSupplier.set("while parsing GUI element '<A>" + debugPathToWidget + "<LR>' of type '<A>" + uiType + "<LR>' in script '<A>" + this.getName() + "<LR>'");
        GuiElementParser parser = guiElementParsers.get(CoreUtilities.toLowerCase((String)uiType));
        if (parser == null) {
            Debug.echoError((String)("Invalid type specified: " + uiType + "."));
            currentContextSupplier.set(previousContext);
            return null;
        }
        Integer width = GuiScriptContainer.getTaggedInt(widgetConfig, "width", 18, context);
        Integer height = GuiScriptContainer.getTaggedInt(widgetConfig, "height", 18, context);
        if (width == null || height == null) {
            Debug.echoError((String)"Invalid width/height specified.");
            currentContextSupplier.set(previousContext);
            return null;
        }
        Integer x = GuiScriptContainer.getTaggedInt(widgetConfig, "x", 0, context);
        Integer y = GuiScriptContainer.getTaggedInt(widgetConfig, "y", 0, context);
        if (x == null || y == null) {
            Debug.echoError((String)"Invalid x/y values specified.");
            currentContextSupplier.set(previousContext);
            return null;
        }
        WWidget widget = parser.parse(this, widgetConfig, pathToWidget, context);
        currentContextSupplier.set(previousContext);
        if (widget == null) {
            return null;
        }
        widget.setLocation(x.intValue(), y.intValue());
        widget.setSize(width.intValue(), height.intValue());
        return widget;
    }

    public static void applyInsets(YamlConfiguration config, Consumer<Insets> setter, TagContext context) {
        Insets insets = GuiScriptContainer.parseInsets(config.getConfigurationSection("insets"), context);
        if (insets != null) {
            setter.accept(insets);
        }
    }

    public static Insets parseInsets(YamlConfiguration config, TagContext context) {
        if (config == null) {
            return null;
        }
        Integer all = GuiScriptContainer.getTaggedInt(config, "all", context);
        if (all != null) {
            return new Insets(all.intValue());
        }
        Integer top = GuiScriptContainer.getTaggedInt(config, "top", context);
        Integer left = GuiScriptContainer.getTaggedInt(config, "left", context);
        Integer bottom = GuiScriptContainer.getTaggedInt(config, "bottom", context);
        Integer right = GuiScriptContainer.getTaggedInt(config, "right", context);
        if (top == null || left == null || bottom == null || right == null) {
            Debug.echoError((String)"Invalid insets: must have top/left/bottom/right values.");
            return null;
        }
        return new Insets(top.intValue(), left.intValue(), bottom.intValue(), right.intValue());
    }

    public static Texture parseTexture(YamlConfiguration config, String path, TagContext context) {
        String pathStr;
        YamlConfiguration textureConfig = config.getConfigurationSection(path);
        String string = pathStr = textureConfig != null ? GuiScriptContainer.getTaggedString(textureConfig, "texture", context) : GuiScriptContainer.getTaggedString(config, path, context);
        if (pathStr == null) {
            if (textureConfig != null) {
                Debug.echoError((String)"Invalid texture: must specify a texture path.");
            }
            return null;
        }
        class_2960 texturePath = class_2960.method_12829((String)pathStr);
        if (texturePath == null) {
            Debug.echoError((String)("Invalid texture: invalid texture path '" + pathStr + "' specified."));
            return null;
        }
        if (textureConfig == null) {
            return new Texture(texturePath);
        }
        Texture.Type type = GuiScriptContainer.getTaggedEnum(Texture.Type.class, Texture.Type.STANDALONE, textureConfig, "type", context);
        if (type == null) {
            Debug.echoError((String)"Invalid texture: invalid type specified.");
            return null;
        }
        Float u = GuiScriptContainer.getTaggedFloat(textureConfig, "u", context);
        Float v = GuiScriptContainer.getTaggedFloat(textureConfig, "v", context);
        Float width = GuiScriptContainer.getTaggedFloat(textureConfig, "width", context);
        Float height = GuiScriptContainer.getTaggedFloat(textureConfig, "height", context);
        if (u == null || v == null || width == null || height == null) {
            Debug.echoError((String)"Invalid texture: invalid UV coordinates specified.");
            return null;
        }
        return new Texture(texturePath, type, u.floatValue(), v.floatValue(), u.floatValue() + width.floatValue(), v.floatValue() + height.floatValue());
    }

    public static Icon parseIcon(YamlConfiguration config, String path, TagContext context) {
        ObjectTag itemObject = GuiScriptContainer.getTaggedObject(ObjectTag.class, config, path, context);
        if (itemObject == null) {
            return null;
        }
        ItemTag item = (ItemTag)itemObject.asType(ItemTag.class, CoreUtilities.noDebugContext);
        if (item != null) {
            return new ItemIcon(item.getStack());
        }
        Texture texture = GuiScriptContainer.parseTexture(config, path, context);
        if (texture == null) {
            Debug.echoError((String)"Invalid icon: must have a valid item or texture.");
            return null;
        }
        return new TextureIcon(texture);
    }

    public static void applyBackgroundPainter(WPanel panel, YamlConfiguration config, TagContext context) {
        BackgroundPainter painter = GuiScriptContainer.parseBackgroundPainter(config, "background", context);
        if (painter != null) {
            panel.setBackgroundPainter(painter);
        }
    }

    public static BackgroundPainter parseBackgroundPainter(YamlConfiguration config, String path, TagContext context) {
        ObjectTag rawObject = GuiScriptContainer.getTaggedObject(ObjectTag.class, config, path, context);
        if (rawObject == null) {
            return null;
        }
        ColorTag color = (ColorTag)rawObject.asType(ColorTag.class, CoreUtilities.noDebugContext);
        if (color != null) {
            return BackgroundPainter.createColorful((int)color.asARGB());
        }
        class_2960 guiSprite = class_2960.method_12829((String)rawObject.toString());
        if (guiSprite != null) {
            return BackgroundPainter.createGuiSprite((class_2960)guiSprite);
        }
        YamlConfiguration painterConfig = config.getConfigurationSection(path);
        if (painterConfig == null) {
            Debug.echoError((String)"Invalid background: must specify a valid single color/texture or a config.");
            return null;
        }
        ColorTag baseColor = GuiScriptContainer.getTaggedObject(ColorTag.class, painterConfig, "color", context);
        if (baseColor == null) {
            Debug.echoError((String)"Invalid background: must specify a color.");
            return null;
        }
        Float contrast = GuiScriptContainer.getTaggedFloat(painterConfig, "contrast", context);
        if (contrast == null) {
            Debug.echoError((String)"Invalid background: must specify a contrast or use the single color format.");
            return null;
        }
        return BackgroundPainter.createColorful((int)baseColor.asARGB(), (float)contrast.floatValue());
    }

    static {
        GuiScriptContainer.registerGuiElement("plain_panel", new PlainPanelElement());
        GuiScriptContainer.registerGuiElement("tab_panel", new TabPanelElement());
        GuiScriptContainer.registerGuiElement("scroll_panel", new ScrollPanelElement());
        GuiScriptContainer.registerGuiElement("grid_panel", new GridPanelElement());
        GuiScriptContainer.registerGuiElement("box_panel", new BoxPanelElement());
        GuiScriptContainer.registerGuiElement("button", new ButtonElement());
        GuiScriptContainer.registerGuiElement("toggle_button", new ToggleButtonElement());
        GuiScriptContainer.registerGuiElement("text", new TextElement());
        GuiScriptContainer.registerGuiElement("label", new LabelElement());
        GuiScriptContainer.registerGuiElement("dynamic_label", new DynamicLabelElement());
        GuiScriptContainer.registerGuiElement("item", new ItemElement());
        GuiScriptContainer.registerGuiElement("text_field", new TextFieldElement());
        GuiScriptContainer.registerGuiElement("slider", new SliderElement());
        GuiScriptContainer.registerGuiElement("labeled_slider", new LabeledSliderElement());
        GuiScriptContainer.registerGuiElement("progress_bar", new ProgressBarElement());
        GuiScriptContainer.registerGuiElement("sprite", new SpriteElement());
        currentContextSupplier = null;
    }

    public static class ContextStringSupplier
    implements Supplier<String> {
        String context;

        public String set(String newContext) {
            String previousContext = this.context;
            this.context = newContext;
            return previousContext;
        }

        @Override
        public String get() {
            return this.context;
        }
    }

    @FunctionalInterface
    public static interface GuiElementParser {
        public WWidget parse(GuiScriptContainer var1, YamlConfiguration var2, String var3, TagContext var4);
    }
}

