/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.network;

import com.denizenscript.clientizen.network.PacketIn;
import com.denizenscript.clientizen.network.PacketOut;
import com.mojang.datafixers.util.Function3;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class Codecs {
    public static final class_9139<class_9129, String> STRING = class_9139.method_56437(Codecs::writeString, Codecs::readString);
    public static final class_9139<class_9129, Map<String, String>> STRING_MAP = class_9139.method_56437(Codecs::writeStringMap, Codecs::readStringMap);
    private static final Function<?, ?> NO_WRITE = param -> {
        throw new UnsupportedOperationException("Trying to write read-only codec.");
    };

    public static <T extends ByteBuf, R> class_9139<T, R> nullable(class_9139<T, R> codec) {
        return class_9139.method_56437((buf, value) -> {
            if (value != null) {
                buf.writeBoolean(true);
                codec.encode(buf, value);
            } else {
                buf.writeBoolean(false);
            }
        }, buf -> buf.readBoolean() ? codec.decode(buf) : null);
    }

    private static <T, R> Function<T, R> noWrite() {
        return NO_WRITE;
    }

    public static <P extends PacketIn, CT> class_9139<class_9129, P> readOnly(class_9139<class_9129, CT> codec, Function<CT, P> constructor) {
        return codec.method_56432(constructor, Codecs.noWrite());
    }

    public static <P extends PacketIn, CT1, CT2> class_9139<class_9129, P> readOnly(class_9139<class_9129, CT1> codec1, class_9139<class_9129, CT2> codec2, BiFunction<CT1, CT2, P> constructor) {
        return class_9139.method_56435(codec1, Codecs.noWrite(), codec2, Codecs.noWrite(), constructor);
    }

    public static <P extends PacketIn, CT1, CT2, CT3> class_9139<class_9129, P> readOnly(class_9139<class_9129, CT1> codec1, class_9139<class_9129, CT2> codec2, class_9139<class_9129, CT3> codec3, Function3<CT1, CT2, CT3, P> constructor) {
        return class_9139.method_56436(codec1, Codecs.noWrite(), codec2, Codecs.noWrite(), codec3, Codecs.noWrite(), constructor);
    }

    private static <T> T noRead() {
        throw new UnsupportedOperationException("Trying to read with write-only codec.");
    }

    public static <P extends PacketOut> class_9139<class_9129, P> noData(Supplier<P> constructor) {
        return class_9139.method_56437((buf, value) -> constructor.get(), buf -> (PacketOut)Codecs.noRead());
    }

    public static <P extends PacketOut, CT> class_9139<class_9129, P> writeOnly(class_9139<class_9129, CT> codec, Function<P, CT> getter) {
        return codec.method_56432(value -> (PacketOut)Codecs.noRead(), getter);
    }

    public static <P extends PacketOut, CT1, CT2> class_9139<class_9129, P> writeOnly(class_9139<class_9129, CT1> codec1, Function<P, CT1> getter1, class_9139<class_9129, CT2> codec2, Function<P, CT2> getter2) {
        return class_9139.method_56435(codec1, getter1, codec2, getter2, (value1, value2) -> (PacketOut)Codecs.noRead());
    }

    public static <P extends PacketOut, CT1, CT2, CT3> class_9139<class_9129, P> writeOnly(class_9139<class_9129, CT1> codec1, Function<P, CT1> getter1, class_9139<class_9129, CT2> codec2, Function<P, CT2> getter2, class_9139<class_9129, CT3> codec3, Function<P, CT3> getter3) {
        return class_9139.method_56436(codec1, getter1, codec2, getter2, codec3, getter3, (value1, value2, value3) -> (PacketOut)Codecs.noRead());
    }

    public static void writeString(ByteBuf buf, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    public static String readString(ByteBuf buf) {
        byte[] bytes = new byte[buf.readInt()];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeStringMap(ByteBuf buf, Map<String, String> stringMap) {
        buf.writeInt(stringMap.size());
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            Codecs.writeString(buf, entry.getKey());
            Codecs.writeString(buf, entry.getValue());
        }
    }

    public static Map<String, String> readStringMap(ByteBuf buf) {
        int size = buf.readInt();
        HashMap<String, String> stringMap = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = Codecs.readString(buf);
            String value = Codecs.readString(buf);
            stringMap.put(key, value);
        }
        return stringMap;
    }
}

