/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.objects;

import com.denizenscript.clientizen.objects.ClientizenObjectRegistry;
import com.denizenscript.clientizen.util.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MaterialTag
implements ObjectTag,
Adjustable {
    public class_2680 state;
    public class_1792 item;
    public static final ObjectTagProcessor<MaterialTag> tagProcessor = new ObjectTagProcessor();
    private String prefix = "Material";

    public MaterialTag(class_2680 state) {
        this.state = state;
    }

    public MaterialTag(class_2248 block) {
        this.state = block.method_9564();
    }

    public MaterialTag(class_1792 item) {
        this.item = item;
    }

    @Fetchable(value="m")
    public static MaterialTag valueOf(String string, TagContext context) {
        class_2960 identifier;
        if (string == null) {
            return null;
        }
        if (ObjectFetcher.isObjectWithProperties((String)string)) {
            return (MaterialTag)ObjectFetcher.getObjectFromWithProperties(ClientizenObjectRegistry.TYPE_MATERIAL, (String)string, (TagContext)context);
        }
        if (string.startsWith("m@")) {
            string = string.substring("m@".length());
        }
        if ((identifier = class_2960.method_12829((String)string)) == null) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf MaterialTag returning null, invalid material/item name or identifier specified. For input: " + string));
            }
            return null;
        }
        MaterialTag material = class_7923.field_41175.method_17966(identifier).map(MaterialTag::new).orElseGet(() -> class_7923.field_41178.method_17966(identifier).map(MaterialTag::new).orElse(null));
        if (material != null) {
            return material;
        }
        if (context == null || context.showErrors()) {
            Debug.echoError((String)("valueOf MaterialTag returning null, invalid material/item specified. For input: " + string));
        }
        return null;
    }

    public static boolean matches(String string) {
        if (string.startsWith("m@")) {
            return true;
        }
        return MaterialTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public String getName() {
        return Utilities.idToString(this.state != null ? class_7923.field_41175.method_10221((Object)this.state.method_26204()) : class_7923.field_41178.method_10221((Object)this.item));
    }

    public boolean isBlock() {
        return this.state != null || class_7923.field_41175.method_10250(class_7923.field_41178.method_10221((Object)this.item));
    }

    public boolean isItem() {
        return this.item != null || class_7923.field_41178.method_10250(class_7923.field_41175.method_10221((Object)this.state.method_26204()));
    }

    public static void register() {
        PropertyParser.registerPropertyTagHandlers(MaterialTag.class, tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.getName()), new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism((ObjectTag)this, mechanism);
    }

    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    public String identify() {
        return "m@" + this.getName() + PropertyParser.getPropertiesString((ObjectTag)this);
    }

    public String identifySimple() {
        return "m@" + this.getName();
    }

    public String debuggable() {
        return "<LG>m@<Y>" + this.getName() + PropertyParser.getPropertiesDebuggable((ObjectTag)this);
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return false;
    }

    public ObjectTag duplicate() {
        return this.state != null ? new MaterialTag(this.state) : new MaterialTag(this.item);
    }

    public boolean advancedMatches(String matcher, TagContext context) {
        return ScriptEvent.createMatcher((String)matcher).doesMatch(this.getName(), text -> switch (text) {
            case "material" -> true;
            case "block" -> this.isBlock();
            case "item" -> this.isItem();
            default -> false;
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

