/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.objects;

import com.denizenscript.clientizen.util.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class ModTag
implements ObjectTag {
    public final ModContainer modContainer;
    public static final ObjectTagProcessor<ModTag> tagProcessor = new ObjectTagProcessor();
    String prefix = "Mod";

    @Fetchable(value="mod")
    public static ModTag valueOf(String input, TagContext context) {
        Optional<ModTag> modTag;
        if (input.startsWith("mod@")) {
            input = input.substring("mod@".length());
        }
        if ((modTag = FabricLoader.getInstance().getModContainer(CoreUtilities.toLowerCase((String)input)).map(ModTag::new)).isEmpty()) {
            Utilities.echoErrorByContext(context, "valueOf ModTag returning null: '" + input + "' isn't a valid mod id.");
            return null;
        }
        return modTag.get();
    }

    public static boolean matches(String string) {
        if (string.startsWith("mod@")) {
            return true;
        }
        return FabricLoader.getInstance().isModLoaded(CoreUtilities.toLowerCase((String)string));
    }

    public ModTag(ModContainer modContainer) {
        this.modContainer = modContainer;
    }

    public ModMetadata getMetadata() {
        return this.modContainer.getMetadata();
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "id", (attribute, object) -> new ElementTag(object.getMetadata().getId(), true), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "display_name", (attribute, object) -> new ElementTag(object.getMetadata().getName(), true), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "description", (attribute, object) -> new ElementTag(object.getMetadata().getDescription(), true), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "version", (attribute, object) -> new ElementTag(object.getMetadata().getVersion().getFriendlyString(), true), new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "authors", (attribute, object) -> Utilities.personsToMap(object.getMetadata().getAuthors()), new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "contributors", (attribute, object) -> Utilities.personsToMap(object.getMetadata().getContributors()), new String[0]);
        tagProcessor.registerStaticTag(MapTag.class, "contact_info", (attribute, object) -> Utilities.contactInfoToMap(object.getMetadata().getContact()), new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "licenses", (attribute, object) -> new ListTag(object.getMetadata().getLicense(), true), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "type", (attribute, object) -> new ElementTag(object.getMetadata().getType(), true), new String[0]);
        tagProcessor.registerStaticTag(ModTag.class, "containing_mod", (attribute, object) -> object.modContainer.getContainingMod().map(ModTag::new).orElse(null), new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "contained_mods", (attribute, object) -> new ListTag(object.modContainer.getContainedMods(), ModTag::new), new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public String identify() {
        return "mod@" + this.getMetadata().getId();
    }

    public String debuggable() {
        return "<LG>mod@<Y>" + this.getMetadata().getId();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ModContainer getJavaObject() {
        return this.modContainer;
    }

    public boolean advancedMatches(String matcher, TagContext context) {
        String matcherLower = CoreUtilities.toLowerCase((String)matcher);
        if (matcherLower.equals("mod")) {
            return true;
        }
        return ScriptEvent.runGenericCheck((String)matcherLower, (String)this.getMetadata().getId());
    }

    public boolean isUnique() {
        return true;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

