/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.EnumHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class RepeatCommand
extends BracedCommand {
    public RepeatCommand() {
        this.setName("repeat");
        this.setSyntax("repeat [stop/next/<amount>] (from:<#>) (as:<name>) [<commands>]");
        this.setRequiredArguments(1, 3);
        this.isProcedural = true;
        this.generateDebug = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, ScriptQueue queue, @ArgLinear @ArgName(value="quantity") @ArgDefaultText(value="-1") int quantity, @ArgName(value="action") @ArgDefaultText(value="run") Action action, @ArgPrefixed @ArgName(value="from") @ArgDefaultText(value="1") int from, @ArgPrefixed @ArgName(value="as") @ArgDefaultText(value="value") String asName) {
        if (action == Action.STOP) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, "repeat", RepeatCommand.db("instruction", "stop"));
            }
            boolean hasnext = false;
            for (int i = 0; i < queue.getQueueSize(); ++i) {
                ScriptEntry entry = queue.getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equals("REPEAT") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (queue.getQueueSize() > 0) {
                    ScriptEntry entry = queue.getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (entry.getCommandName().equals("REPEAT") && args.size() == 1 && args.get(0).equals("\u0000CALLBACK")) {
                        ((RepeatData)entry.getOwner().getData()).reapplyAtEnd(queue);
                        queue.removeFirst();
                        break;
                    }
                    queue.removeFirst();
                }
            } else {
                Debug.echoError("Cannot stop repeat: not in one!");
            }
            return;
        }
        if (action == Action.NEXT) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, "repeat", RepeatCommand.db("instruction", "next"));
            }
            boolean hasnext = false;
            for (int i = 0; i < queue.getQueueSize(); ++i) {
                ScriptEntry entry = queue.getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equals("REPEAT") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (queue.getQueueSize() > 0) {
                    ScriptEntry entry = queue.getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (!entry.getCommandName().equals("REPEAT") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) {
                        queue.removeFirst();
                        continue;
                    }
                    break;
                }
            } else {
                Debug.echoError("Cannot 'repeat next': not in one!");
            }
            return;
        }
        if (action == Action.CALLBACK) {
            if (scriptEntry.getOwner() != null && (scriptEntry.getOwner().getCommandName().equals("REPEAT") || scriptEntry.getOwner().getBracedSet() == null || scriptEntry.getOwner().getBracedSet().isEmpty() || scriptEntry.getBracedSet().get((int)0).value.get(scriptEntry.getBracedSet().get((int)0).value.size() - 1) != scriptEntry)) {
                RepeatData data = (RepeatData)scriptEntry.getOwner().getData();
                ++data.index;
                if (data.index <= data.target) {
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "Repeat loop " + data.index);
                    }
                    queue.addDefinition(data.valueName, String.valueOf(data.index));
                    List<ScriptEntry> bracedCommands = BracedCommand.getBracedCommandsDirect(scriptEntry.getOwner(), scriptEntry);
                    ScriptEntry callbackEntry = scriptEntry.clone();
                    callbackEntry.copyFrom(scriptEntry);
                    callbackEntry.setOwner(scriptEntry.getOwner());
                    bracedCommands.add(callbackEntry);
                    for (ScriptEntry cmd : bracedCommands) {
                        cmd.setInstant(true);
                    }
                    queue.injectEntriesAtStart(bracedCommands);
                } else {
                    data.reapplyAtEnd(queue);
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "Repeat loop complete");
                    }
                }
            } else {
                Debug.echoError("Repeat CALLBACK invalid: not a real callback!");
            }
        } else {
            if (quantity == -1) {
                throw new InvalidArgumentsRuntimeException("Must specify a quantity or 'stop' or 'next'!");
            }
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, "repeat", RepeatCommand.db("from", from), RepeatCommand.db("times", quantity), RepeatCommand.db("as_name", asName));
            }
            if (quantity <= 0) {
                if (scriptEntry.dbCallShouldDebug()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Zero count, not looping...");
                }
                return;
            }
            RepeatData datum = new RepeatData();
            datum.index = from;
            datum.target = datum.index + quantity - 1;
            datum.valueName = asName;
            scriptEntry.setData(datum);
            ScriptEntry callbackEntry = RepeatCommand.getCallback(scriptEntry);
            List<ScriptEntry> bracedCommandsList = RepeatCommand.getBracedCommandsDirect(scriptEntry, scriptEntry);
            if (bracedCommandsList == null || bracedCommandsList.isEmpty()) {
                Debug.echoError(scriptEntry, "Empty subsection - did you forget a ':'?");
                return;
            }
            datum.originalValue = queue.getDefinitionObject(datum.valueName);
            queue.addDefinition(datum.valueName, String.valueOf(datum.index));
            callbackEntry.copyFrom(scriptEntry);
            callbackEntry.setOwner(scriptEntry);
            bracedCommandsList.add(callbackEntry);
            for (ScriptEntry cmd : bracedCommandsList) {
                cmd.setInstant(true);
            }
            scriptEntry.setInstant(true);
            queue.injectEntriesAtStart(bracedCommandsList);
        }
    }

    public static ScriptEntry getCallback(ScriptEntry forEntry) {
        if (forEntry.internal.specialProcessedData == null) {
            forEntry.internal.specialProcessedData = new ScriptEntry("REPEAT", new String[]{"\u0000CALLBACK"}, forEntry.getScript() != null ? forEntry.getScript().getContainer() : null);
        }
        return ((ScriptEntry)forEntry.internal.specialProcessedData).clone();
    }

    static {
        EnumHelper<Action> enumHack = EnumHelper.get(Action.class);
        enumHack.valuesMapLower.remove("callback");
        enumHack.valuesMapLower.put("\u0000callback", Action.CALLBACK);
    }

    public static enum Action {
        RUN,
        STOP,
        NEXT,
        CALLBACK;

    }

    private static class RepeatData {
        public int index;
        public int target;
        public String valueName;
        public ObjectTag originalValue;

        private RepeatData() {
        }

        public void reapplyAtEnd(ScriptQueue queue) {
            queue.addDefinition(this.valueName, this.originalValue);
        }
    }
}

