/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.List;

public class EventCommand
extends AbstractCommand {
    public EventCommand() {
        this.setName("event");
        this.setSyntax("event [<event name>|...] (context:<name>|<object>|...)");
        this.setRequiredArguments(1, 2);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("context") && arg.matchesPrefix("context", "c")) {
                scriptEntry.addObject("context", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("events")) {
                scriptEntry.addObject("events", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("events")) {
            throw new InvalidArgumentsException("Must specify a list of event names!");
        }
        scriptEntry.defaultObject("context", new ListTag());
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag events = (ListTag)scriptEntry.getObject("events");
        ListTag context = (ListTag)scriptEntry.getObject("context");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), events.debug() + context.debug());
        }
        if (context.size() % 2 == 1) {
            context.add("null");
        }
        HashMap<String, ObjectTag> context_map = new HashMap<String, ObjectTag>();
        for (int i = 0; i < context.size(); i += 2) {
            context_map.put((String)context.get(i), ObjectFetcher.pickObjectFor((String)context.get(i + 1), scriptEntry.entryData.getTagContext()));
        }
        List<String> Determination = OldEventManager.doEvents(events, scriptEntry.entryData, context_map, true);
        scriptEntry.addObject("determinations", new ListTag(Determination));
    }
}

