/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.scripts.commands.Comparable;
import com.denizenscript.denizencore.scripts.commands.queue.ElseCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;

public class IfCommand
extends BracedCommand {
    public IfCommand() {
        this.setName("if");
        this.setSyntax("if [<value>] (!)(<operator> <value>) (&&/|| ...) [<commands>]");
        this.setRequiredArguments(1, -1);
        this.setParseArgs(false);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean has_brace;
        boolean bl = has_brace = scriptEntry.getInsideList() != null;
        if (has_brace) {
            ScriptEntry nextEntry;
            ArrayList allData = new ArrayList();
            BracedCommand.BracedData ifRef = IfCommand.getBracedCommands(scriptEntry).get(0);
            ifRef.key = scriptEntry.toString();
            ifRef.args = new ArrayList<String>();
            ifRef.args.add("if");
            ifRef.args.addAll(scriptEntry.getOriginalArguments());
            allData.add(ifRef);
            while (scriptEntry.getResidingQueue().script_entries.size() > 0 && (nextEntry = scriptEntry.getResidingQueue().script_entries.get(0)).getCommand() instanceof ElseCommand) {
                if (nextEntry.getInsideList() == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Upcoming else command is mis-formatted!");
                    break;
                }
                scriptEntry.getResidingQueue().script_entries.remove(0);
                BracedCommand.BracedData elseRef = IfCommand.getBracedCommands(nextEntry).get(0);
                elseRef.key = nextEntry.toString();
                elseRef.args = new ArrayList<String>();
                elseRef.args.add("else");
                elseRef.args.addAll(nextEntry.getArguments());
                allData.add(elseRef);
            }
            scriptEntry.addObject("braces", allData);
        } else {
            for (String arg : scriptEntry.getArguments()) {
                if (!arg.equalsIgnoreCase("{")) continue;
                if (Debug.verbose) {
                    Debug.log("Has_brace = true");
                }
                has_brace = true;
                break;
            }
            if (has_brace) {
                scriptEntry.addObject("braces", IfCommand.getBracedCommands(scriptEntry));
            }
        }
        boolean in_subcommand = false;
        boolean in_elsecommand = false;
        ArrayList<String> subcommand = new ArrayList<String>();
        ArrayList<String> elsecommand = new ArrayList<String>();
        ArrayList<String> comparisons = new ArrayList<String>();
        for (String arg : scriptEntry.getArguments()) {
            if (arg.equalsIgnoreCase("{")) break;
            if (!has_brace && in_subcommand && arg.equalsIgnoreCase("else")) {
                in_elsecommand = true;
                in_subcommand = false;
                continue;
            }
            if (!has_brace && !in_elsecommand && DenizenCore.getCommandRegistry().get(arg.toUpperCase()) != null) {
                Deprecations.ifCommandSingleLine.warn(scriptEntry);
                in_subcommand = true;
                subcommand.add(arg);
                continue;
            }
            if (!has_brace && in_subcommand) {
                subcommand.add(arg);
                continue;
            }
            if (!has_brace && in_elsecommand) {
                elsecommand.add(arg);
                continue;
            }
            comparisons.add(arg);
        }
        if (!has_brace && in_elsecommand) {
            scriptEntry.addObject("elsecommand", elsecommand);
        }
        if (!has_brace && (in_subcommand || in_elsecommand)) {
            scriptEntry.addObject("subcommand", subcommand);
        }
        scriptEntry.addObject("comparisons", comparisons);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        boolean first_set;
        List subcommand = (List)scriptEntry.getObject("subcommand");
        List elsecommand = (List)scriptEntry.getObject("elsecommand");
        List comparisons = (List)scriptEntry.getObject("comparisons");
        List braces = (List)scriptEntry.getObject("braces");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("use_braces", braces != null));
        }
        if (Debug.verbose) {
            Debug.log("comparisons=" + comparisons + ", sc:" + subcommand + ", ec:" + elsecommand);
        }
        if ((first_set = new ArgComparer().compare(comparisons, scriptEntry)) && subcommand != null && subcommand.size() > 0) {
            this.executeCommandList(subcommand, scriptEntry);
            return;
        }
        if (!first_set && elsecommand != null && elsecommand.size() > 0) {
            this.executeCommandList(elsecommand, scriptEntry);
            return;
        }
        if (braces != null) {
            if (braces.isEmpty()) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Failed to parse IF command: mis-aligned bracing, empty subsections, or other basic formatting error.");
                return;
            }
            if (first_set) {
                if (Debug.verbose) {
                    Debug.log("Running the first set");
                }
                Debug.echoDebug((Debuggable)scriptEntry, "<Y>If command passed, running block.");
                scriptEntry.setInstant(true);
                List<ScriptEntry> bracedCommandsList = ((BracedCommand.BracedData)braces.get((int)0)).value;
                for (int i = 0; i < bracedCommandsList.size(); ++i) {
                    bracedCommandsList.get(i).setInstant(true);
                }
                scriptEntry.getResidingQueue().injectEntries(bracedCommandsList, 0);
                return;
            }
            for (int z = 1; z < braces.size(); ++z) {
                List<String> key;
                BracedCommand.BracedData braceSet = (BracedCommand.BracedData)braces.get(z);
                if (Debug.verbose) {
                    Debug.log("Trying: " + braceSet.key);
                }
                if ((key = braceSet.args).isEmpty() || !key.get(0).equalsIgnoreCase("else")) {
                    Debug.echoError("If command has argument '" + key.get(0) + "' which is unknown.");
                    continue;
                }
                if (key.size() > 1) {
                    if (!key.get(1).equalsIgnoreCase("if")) {
                        Debug.echoError("Else command has argument '" + key.get(1) + "' which is unknown.");
                        continue;
                    }
                    if (!new ArgComparer().compare(key.subList(2, key.size()), scriptEntry)) continue;
                    Debug.echoDebug((Debuggable)scriptEntry, "<Y>If/else-if chain entry #" + (z + 1) + " passed, running block.");
                } else {
                    Debug.echoDebug((Debuggable)scriptEntry, "<Y>No part of the if command passed, running ELSE block.");
                }
                scriptEntry.setInstant(true);
                List<ScriptEntry> bracedCommandsList = braceSet.value;
                for (int i = 0; i < bracedCommandsList.size(); ++i) {
                    bracedCommandsList.get(i).setInstant(true);
                }
                scriptEntry.getResidingQueue().injectEntries(bracedCommandsList, 0);
                return;
            }
        }
        Debug.echoDebug((Debuggable)scriptEntry, "<Y>No part of the if command passed, no block will run.");
    }

    public void executeCommandList(List<String> subcommand, ScriptEntry scriptEntry) {
        try {
            scriptEntry.setInstant(true);
            String cmd = subcommand.get(0);
            subcommand.remove(0);
            ScriptEntry entry = new ScriptEntry(cmd, subcommand.toArray(new String[0]), scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
            entry.entryData = scriptEntry.entryData.clone();
            entry.updateContext();
            entry.setInstant(true);
            scriptEntry.getResidingQueue().injectEntry(entry, 0);
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    public static class ArgComparer {
        List argstemp = null;
        ArgInternal[] argstemp_parsed = null;
        ScriptEntry scriptEntry = null;
        Boolean result = null;
        boolean flip = false;

        public String toString() {
            return "[ArgComp: " + this.argstemp + " res " + this.result + "]";
        }

        public static String procString(Object arg) {
            if (arg instanceof String) {
                return (String)arg;
            }
            if (arg instanceof ArgInternal) {
                return arg.toString();
            }
            if (arg instanceof ArgComparer) {
                return ((ArgComparer)arg).compare() ? "true" : "false";
            }
            if (arg instanceof Boolean) {
                return (Boolean)arg != false ? "true" : "false";
            }
            return arg.toString();
        }

        public static String procStringNoTag(Object arg) {
            if (arg instanceof String) {
                return (String)arg;
            }
            if (arg instanceof ArgInternal) {
                return arg.toString();
            }
            if (arg instanceof ArgComparer) {
                return "<UnTaggedComparison>";
            }
            if (arg instanceof Boolean) {
                return (Boolean)arg != false ? "true" : "false";
            }
            return arg.toString();
        }

        public boolean tagbool(int arg) {
            if (this.argstemp_parsed[arg] != null) {
                return this.argstemp_parsed[arg].boolify();
            }
            Object argObj = this.argstemp.get(arg);
            if (argObj instanceof String) {
                return this.tagify((String)argObj).boolify();
            }
            if (argObj instanceof ArgInternal) {
                return ((ArgInternal)argObj).boolify();
            }
            if (argObj instanceof ArgComparer) {
                return ((ArgComparer)argObj).compare();
            }
            if (argObj instanceof Boolean) {
                return (Boolean)argObj;
            }
            return this.tagify(argObj.toString()).boolify();
        }

        public ArgInternal tagify(String arg) {
            ArgInternal toRet = new ArgInternal();
            if (arg.startsWith("!")) {
                toRet.negative = true;
                arg = arg.substring(1);
            }
            toRet.value = TagManager.tag(arg, DenizenCore.getImplementation().getTagContext(this.scriptEntry));
            return toRet;
        }

        public ArgInternal tagme(int arg) {
            ArgInternal got;
            if (this.argstemp_parsed[arg] != null) {
                return this.argstemp_parsed[arg];
            }
            this.argstemp_parsed[arg] = got = this.tagify(ArgComparer.procString(this.argstemp.get(arg)));
            return got;
        }

        public ArgComparer construct(List args, ScriptEntry scriptEntry) {
            this.argstemp = args;
            this.argstemp_parsed = new ArgInternal[args.size()];
            this.scriptEntry = scriptEntry;
            return this;
        }

        public boolean compare(List args, ScriptEntry scriptEntry) {
            this.construct(args, scriptEntry);
            return this.compare();
        }

        public boolean compare() {
            if (this.result == null) {
                this.result = this.compareInternal();
                if (this.flip) {
                    this.result = this.result == false;
                }
            }
            return this.result;
        }

        public boolean compareInternal() {
            int x;
            String arg;
            int i;
            List args = this.argstemp;
            if (Debug.verbose) {
                Debug.log("Comparing " + args);
            }
            if (args.isEmpty()) {
                if (Debug.verbose) {
                    Debug.log("Args.size == 0, return false");
                }
                return false;
            }
            if (args.size() == 1) {
                if (Debug.verbose) {
                    Debug.log("Returning comparison for " + args.get(0));
                }
                return this.tagbool(0);
            }
            for (i = 0; i < args.size(); ++i) {
                arg = ArgComparer.procStringNoTag(args.get(i));
                if (arg.equals("(") || arg.equals("!(")) {
                    ArrayList<String> subargs = new ArrayList<String>(args.size());
                    int count = 0;
                    boolean found = false;
                    for (x = i + 1; x < args.size(); ++x) {
                        String xarg = ArgComparer.procStringNoTag(args.get(x));
                        if (xarg.equals("(") || xarg.equals("!(")) {
                            ++count;
                            subargs.add(xarg);
                            if (!Debug.verbose) continue;
                            Debug.log("Open paren");
                            continue;
                        }
                        if (xarg.equals(")")) {
                            if (Debug.verbose) {
                                Debug.log("Close paren");
                            }
                            if (--count == -1) {
                                if (Debug.verbose) {
                                    Debug.log("Crunch");
                                }
                                ArgComparer comp = new ArgComparer().construct(subargs, this.scriptEntry);
                                comp.flip = arg.startsWith("!");
                                for (int c = 0; c < x - i + 1; ++c) {
                                    args.remove(i);
                                }
                                args.add(i, comp);
                                found = true;
                                if (!Debug.verbose) break;
                                Debug.log("Shrunk to " + args);
                                break;
                            }
                            subargs.add(")");
                            continue;
                        }
                        subargs.add((String)args.get(x));
                    }
                    if (found) continue;
                    if (Debug.verbose) {
                        Debug.log("Returning false: strange(unfound) ()");
                    }
                    return false;
                }
                if (!arg.equals(")")) continue;
                if (Debug.verbose) {
                    Debug.log("Returning false: strange(stray) ()");
                }
                return false;
            }
            if (args.size() == 1) {
                if (Debug.verbose) {
                    Debug.log("Returning comparison for " + args.get(0));
                }
                return this.tagbool(0);
            }
            for (i = 0; i < args.size(); ++i) {
                boolean comp;
                boolean before;
                int x2;
                ArrayList beforeargs;
                arg = ArgComparer.procStringNoTag(args.get(i));
                if (arg.equalsIgnoreCase("||")) {
                    beforeargs = new ArrayList(i);
                    for (x2 = 0; x2 < i; ++x2) {
                        beforeargs.add(args.get(x2));
                    }
                    before = new ArgComparer().compare(beforeargs, this.scriptEntry);
                    if (before) {
                        if (Debug.verbose) {
                            Debug.log("Returning true because true || irrel");
                        }
                        return true;
                    }
                    ArrayList afterargs = new ArrayList(args.size() - (i + 1));
                    for (x = i + 1; x < args.size(); ++x) {
                        afterargs.add(args.get(x));
                    }
                    comp = new ArgComparer().compare(afterargs, this.scriptEntry);
                    if (Debug.verbose) {
                        Debug.log("Returning || comparison: " + comp);
                    }
                    return comp;
                }
                if (!arg.equalsIgnoreCase("&&")) continue;
                beforeargs = new ArrayList(i);
                for (x2 = 0; x2 < i; ++x2) {
                    beforeargs.add(args.get(x2));
                }
                before = new ArgComparer().compare(beforeargs, this.scriptEntry);
                if (!before) {
                    if (Debug.verbose) {
                        Debug.log("Returning false because false && irrel");
                    }
                    return false;
                }
                ArrayList afterargs = new ArrayList(args.size() - (i + 1));
                for (x = i + 1; x < args.size(); ++x) {
                    afterargs.add(args.get(x));
                }
                comp = new ArgComparer().compare(afterargs, this.scriptEntry);
                if (Debug.verbose) {
                    Debug.log("Returning && comparison: " + comp);
                }
                return comp;
            }
            if (args.size() == 1) {
                if (Debug.verbose) {
                    Debug.log("Returning comparison for " + args.get(0));
                }
                return this.tagbool(0);
            }
            if (args.size() == 2) {
                if (Debug.verbose) {
                    Debug.log("Returning false because two args only (non-processable)");
                }
                return false;
            }
            String arg2 = ArgComparer.procStringNoTag(args.get(1));
            boolean negative = false;
            if (arg2.startsWith("!")) {
                arg2 = arg2.substring(1);
                negative = true;
            }
            if (arg2.equals("==") || arg2.equals("=")) {
                arg2 = "EQUALS";
            } else if (arg2.equals(">=")) {
                arg2 = "OR_MORE";
            } else if (arg2.equals("<=")) {
                arg2 = "OR_LESS";
            } else if (arg2.equals("<")) {
                arg2 = "LESS";
            } else if (arg2.equals(">")) {
                arg2 = "MORE";
            } else if (arg2.equals("||")) {
                arg2 = "OR";
            } else if (arg2.equals("&&")) {
                arg2 = "AND";
            }
            Comparable comparable = new Comparable();
            if (negative) {
                comparable.logic = Comparable.Logic.NEGATIVE;
            }
            try {
                comparable.operator = Comparable.Operator.valueOf(arg2.toUpperCase());
                comparable.setComparable(this.tagme(0).toString());
                comparable.setComparedto(this.tagme(2).toString());
                boolean outcome = comparable.determineOutcome();
                Debug.echoDebug((Debuggable)this.scriptEntry, comparable.toString());
                return outcome;
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError(this.scriptEntry == null ? null : this.scriptEntry.getResidingQueue(), "If command syntax invalid - possibly wrong number of arguments (check for stray spaces)? IllegalArgumentException: " + ex.getMessage());
                return false;
            }
        }

        public static class ArgInternal {
            boolean negative;
            String value;

            boolean boolify() {
                return this.negative != this.value.equals("true");
            }

            public String toString() {
                return this.negative ? "!" + this.value : this.value;
            }
        }
    }
}

