/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class RandomCommand
extends BracedCommand {
    private int previous = 0;
    private int previous2 = 0;
    private int previous3 = 0;

    public RandomCommand() {
        this.setName("random");
        this.setSyntax("random [<commands>]");
        this.setRequiredArguments(0, 1);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        List<BracedCommand.BracedData> bdat = RandomCommand.getBracedCommands(scriptEntry);
        if (bdat != null && bdat.size() > 0) {
            scriptEntry.addObject("braces", bdat);
        }
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matches("{")) break;
            if (!scriptEntry.hasObject("possibilities") && arg.matchesInteger()) {
                scriptEntry.addObject("possibilities", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("braces")) {
            if (!scriptEntry.hasObject("possibilities")) {
                throw new InvalidArgumentsException("Missing possibilities!");
            }
            if (scriptEntry.getElement("possibilities").asInt() <= 1) {
                throw new InvalidArgumentsException("Must randomly select more than one item.");
            }
            if (scriptEntry.getResidingQueue().getQueueSize() < scriptEntry.getElement("possibilities").asInt()) {
                throw new InvalidArgumentsException("Invalid Size! Random # must not be larger than the script!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int possibilities;
        ScriptQueue queue = scriptEntry.getResidingQueue();
        List<ScriptEntry> bracedCommands = null;
        if (!scriptEntry.hasObject("braces")) {
            possibilities = scriptEntry.getElement("possibilities").asInt();
        } else {
            bracedCommands = ((BracedCommand.BracedData)((List)scriptEntry.getObject((String)"braces")).get((int)0)).value;
            possibilities = bracedCommands.size();
        }
        int selected = CoreUtilities.getRandom().nextInt(possibilities);
        if (selected == this.previous || selected == this.previous2 || selected == this.previous3) {
            selected = CoreUtilities.getRandom().nextInt(possibilities);
        }
        if (selected == this.previous || selected == this.previous2 || selected == this.previous3) {
            selected = CoreUtilities.getRandom().nextInt(possibilities);
        }
        this.previous3 = this.previous2;
        this.previous2 = this.previous;
        this.previous = selected;
        scriptEntry.addObject("possibilities", new ElementTag(possibilities));
        scriptEntry.addObject("selected", new ElementTag(selected));
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("possibilities", possibilities) + ArgumentHelper.debugObj("choice", selected + 1));
        }
        scriptEntry.setInstant(true);
        if (bracedCommands == null) {
            ScriptEntry keeping = null;
            for (int x = 0; x < possibilities; ++x) {
                if (x != selected) {
                    queue.removeEntry(0);
                    continue;
                }
                Debug.echoDebug((Debuggable)scriptEntry, "...selected '" + queue.getEntry(0).getCommandName() + ": " + queue.getEntry(0).getArguments() + "'.");
                keeping = queue.getEntry(0);
                queue.removeEntry(0);
            }
            queue.injectEntry(keeping, 0);
        } else {
            queue.injectEntry(bracedCommands.get(selected), 0);
        }
    }
}

