/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import com.denizenscript.denizencore.events.core.DeltaTimeScriptEvent;
import com.denizenscript.denizencore.events.core.PreScriptReloadScriptEvent;
import com.denizenscript.denizencore.events.core.ReloadScriptsScriptEvent;
import com.denizenscript.denizencore.events.core.SystemTimeScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptEntrySet;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.WorldScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public abstract class ScriptEvent
implements ContextSource,
Cloneable {
    public static ArrayList<WorldScriptContainer> worldContainers = new ArrayList();
    public static ArrayList<ScriptEvent> events = new ArrayList();
    public static HashMap<String, ScriptEvent> eventLookup = new HashMap();
    public StatData stats = new StatData();
    public ArrayList<ScriptPath> eventPaths = new ArrayList();
    public boolean cancelled = false;
    public static HashSet<String> defaultDeterminations = new HashSet<String>(Arrays.asList("cancelled", "cancelled:true", "cancelled:false"));
    private String currentEvent;
    public static final HashMap<String, Pattern> knownPatterns = new HashMap();

    public ScriptEvent clone() {
        try {
            return (ScriptEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Debug.echoError("Clone not supported for script events?!");
            return this;
        }
    }

    public static void registerCoreEvents() {
        ScriptEvent.registerScriptEvent(new ConsoleOutputScriptEvent());
        ScriptEvent.registerScriptEvent(new DeltaTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new PreScriptReloadScriptEvent());
        ScriptEvent.registerScriptEvent(new ReloadScriptsScriptEvent());
        ScriptEvent.registerScriptEvent(new SystemTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new TickScriptEvent());
    }

    public static void registerScriptEvent(ScriptEvent event) {
        events.add(event);
        eventLookup.put(CoreUtilities.toLowerCase(event.getName()), event);
    }

    public static void reload() {
        if (Debug.showLoading) {
            Debug.log("Reloading script events...");
        }
        for (ScriptContainer scriptContainer : worldContainers) {
            if (!scriptContainer.getContents().getString("enabled", "true").equalsIgnoreCase("true")) continue;
            YamlConfiguration yamlConfiguration = scriptContainer.getConfigurationSection("events");
            if (yamlConfiguration == null) {
                Debug.echoError("Missing or invalid events block for " + scriptContainer.getName());
                continue;
            }
            for (StringHolder evt : yamlConfiguration.getKeys(false)) {
                if (evt == null || evt.str == null) {
                    Debug.echoError("Missing or invalid events block for " + scriptContainer.getName());
                    continue;
                }
                if (!CoreUtilities.contains(evt.str, '@')) continue;
                Debug.echoError("Script '" + scriptContainer.getName() + "' has event '" + evt.str.replace("@", "<R>@<W>") + "' which contains object notation, which is deprecated for use in world events. Please remove it.");
            }
        }
        ArrayList<ScriptPath> paths = new ArrayList<ScriptPath>(worldContainers.size() * 3);
        for (ScriptContainer scriptContainer : worldContainers) {
            YamlConfiguration config = scriptContainer.getConfigurationSection("events");
            if (config == null) continue;
            for (StringHolder evt1 : config.getKeys(false)) {
                String evt = evt1.str.substring("on ".length()).replace("&dot", ".").replace("&amp", "&");
                ScriptPath path = new ScriptPath(scriptContainer, evt, evt1.str);
                if (path.set == null) {
                    Debug.echoError("Script path '" + path + "' is invalid (empty or misconfigured).");
                    continue;
                }
                paths.add(path);
            }
        }
        for (ScriptEvent scriptEvent : events) {
            try {
                scriptEvent.destroy();
                scriptEvent.eventPaths.clear();
                boolean matched = false;
                for (ScriptPath path : paths) {
                    if (!scriptEvent.couldMatch(path)) continue;
                    scriptEvent.eventPaths.add(path);
                    path.matches.add(scriptEvent);
                    if (Debug.showLoading) {
                        Debug.log("Event match, " + scriptEvent.getName() + " matched for '" + path + "'!");
                    }
                    matched = true;
                }
                if (!matched) continue;
                scriptEvent.sort();
                scriptEvent.init();
            }
            catch (Throwable ex) {
                Debug.echoError("Failed to reload event '" + scriptEvent.getName() + "':");
                Debug.echoError(ex);
            }
        }
        for (ScriptPath scriptPath : paths) {
            if (scriptPath.matches.size() > 1) {
                Debug.log("Event " + scriptPath + " is matched to multiple ScriptEvents: " + CoreUtilities.join(", ", scriptPath.matches));
                continue;
            }
            if (!scriptPath.matches.isEmpty()) continue;
            Debug.log("Event " + scriptPath + " is not matched to any ScriptEvents.");
        }
    }

    public static boolean matchesScript(ScriptEvent sEvent, ScriptPath path) {
        if (path.switch_cancelled != null ? path.switch_cancelled != sEvent.cancelled : (path.switch_ignoreCancelled != null ? path.switch_ignoreCancelled == false && sEvent.cancelled : sEvent.cancelled)) {
            return false;
        }
        return sEvent.matches(path);
    }

    public void sort() {
        try {
            for (ScriptPath path : this.eventPaths) {
                String gotten = path.switches.get("priority");
                path.priority = gotten == null ? 0 : Integer.parseInt(gotten);
            }
        }
        catch (NumberFormatException ex) {
            Debug.echoError("Failed to sort events: not-a-number priority value! " + ex.getMessage());
        }
        Collections.sort(this.eventPaths, new Comparator<ScriptPath>(){

            @Override
            public int compare(ScriptPath scriptPath, ScriptPath t1) {
                int rel = scriptPath.priority - t1.priority;
                return rel < 0 ? -1 : (rel > 0 ? 1 : 0);
            }
        });
    }

    public void init() {
    }

    public void destroy() {
    }

    public void cancellationChanged() {
    }

    public static boolean isDefaultDetermination(ObjectTag determination) {
        if (!(determination instanceof ElementTag)) {
            return false;
        }
        String low = CoreUtilities.toLowerCase(determination.toString());
        return defaultDeterminations.contains(low);
    }

    public boolean applyDetermination(ScriptPath path, ObjectTag determination) {
        String low = CoreUtilities.toLowerCase(determination.toString());
        if (low.equals("cancelled")) {
            Debug.echoDebug((Debuggable)path.container, "Event cancelled!");
            this.cancelled = true;
            this.cancellationChanged();
            return true;
        }
        if (low.equals("cancelled:true")) {
            Debug.echoDebug((Debuggable)path.container, "Event cancelled!");
            this.cancelled = true;
            this.cancellationChanged();
            return true;
        }
        if (low.equals("cancelled:false")) {
            Debug.echoDebug((Debuggable)path.container, "Event uncancelled!");
            this.cancelled = false;
            this.cancellationChanged();
            return true;
        }
        Debug.echoError("Unknown determination '" + determination + "'");
        return false;
    }

    public ScriptEntryData getScriptEntryData() {
        return DenizenCore.getImplementation().getEmptyScriptEntryData();
    }

    public boolean couldMatch(ScriptPath path) {
        throw new UnsupportedOperationException("CouldMatch not implemented for event '" + this.getName() + "'! Report this error to the Denizen developers!");
    }

    public boolean matches(ScriptPath path) {
        throw new UnsupportedOperationException("Matches not implemented for event '" + this.getName() + "'! Report this error to the Denizen developers!");
    }

    public abstract String getName();

    public void fire() {
        ScriptEvent copy = this.clone();
        ++this.stats.fires;
        for (ScriptPath path : this.eventPaths) {
            try {
                if (!ScriptEvent.matchesScript(this, path)) continue;
                copy.run(path);
            }
            catch (Exception e) {
                Debug.echoError("Handling script " + path.container.getName() + " path:" + path.event + ":::");
                Debug.echoError(e);
            }
        }
    }

    public void run(ScriptPath path) {
        ++this.stats.scriptFires;
        if (path.container.shouldDebug()) {
            Debug.echoDebug((Debuggable)path.container, "<Y>Running script event '<A>" + this.getName() + "<Y>', event='<A>" + path.event + "<Y>' for script '<A>" + path.container.getName() + "<Y>'");
        }
        List<ScriptEntry> entries = ScriptContainer.cleanDup(this.getScriptEntryData(), path.set);
        ScriptQueue queue = new InstantQueue(path.container.getName()).addEntries(entries);
        this.currentEvent = path.event;
        queue.setContextSource(this);
        queue.determinationTarget = o -> this.applyDetermination(path, o);
        queue.start();
        this.stats.nanoTimes += System.nanoTime() - queue.startTime;
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("cancelled")) {
            return new ElementTag(this.cancelled);
        }
        if (name.equals("event_header")) {
            return new ElementTag(this.currentEvent);
        }
        if (name.equals("event_name")) {
            return new ElementTag(this.getName());
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static String quotify(String input) {
        StringBuilder output = new StringBuilder(input.length());
        int last = 0;
        int index = input.indexOf(42);
        while (index >= 0) {
            output.append(Pattern.quote(input.substring(last, index))).append("(.*)");
            last = index + 1;
            index = input.indexOf(42, last);
        }
        output.append(Pattern.quote(input.substring(last)));
        return output.toString();
    }

    public static boolean isRegexMatchable(String input) {
        return input.startsWith("regex:") || CoreUtilities.contains(input, '|') || CoreUtilities.contains(input, '*');
    }

    public static Pattern regexHandle(String input) {
        String output;
        Pattern result = knownPatterns.get(input);
        if (result != null) {
            return result;
        }
        if (input.startsWith("regex:")) {
            output = input.substring("regex:".length());
        } else if (CoreUtilities.contains(input, '|')) {
            CharSequence[] split = input.split("\\|");
            for (int i = 0; i < split.length; ++i) {
                split[i] = ScriptEvent.quotify((String)split[i]);
            }
            output = String.join((CharSequence)"|", split);
        } else if (CoreUtilities.contains(input, '*')) {
            output = ScriptEvent.quotify(input);
        } else {
            return null;
        }
        if (Debug.verbose) {
            Debug.log("Event regex compile: " + output);
        }
        result = Pattern.compile(output);
        knownPatterns.put(input, result);
        return result;
    }

    public static boolean equalityCheck(String input, String compared, Pattern regexed) {
        return (input = CoreUtilities.toLowerCase(input)).equals(compared) || regexed != null && regexed.matcher(input).matches();
    }

    public boolean runGenericCheck(String inputValue, String trueValue) {
        if (inputValue != null) {
            trueValue = CoreUtilities.toLowerCase(trueValue);
            if ((inputValue = CoreUtilities.toLowerCase(inputValue)).equals(trueValue)) {
                return true;
            }
            Pattern regexd = ScriptEvent.regexHandle(inputValue);
            if (!ScriptEvent.equalityCheck(trueValue, inputValue, regexd)) {
                return false;
            }
        }
        return true;
    }

    public boolean runGenericSwitchCheck(ScriptPath path, String switchName, String value) {
        String with = path.switches.get(switchName);
        if (with != null) {
            if (value == null) {
                return false;
            }
            value = CoreUtilities.toLowerCase(value);
            if ((with = CoreUtilities.toLowerCase(with)).equals(value)) {
                return true;
            }
            Pattern regexd = ScriptEvent.regexHandle(with);
            if (!ScriptEvent.equalityCheck(value, with, regexd)) {
                return false;
            }
        }
        return true;
    }

    public static class ScriptPath {
        public ScriptContainer container;
        public String event;
        public String eventLower;
        public int priority = 0;
        public ScriptEntrySet set;
        public Boolean switch_cancelled;
        public Boolean switch_ignoreCancelled;
        public HashMap<String, String> switches = new HashMap();
        public String[] eventArgs;
        public String[] eventArgsLower;
        public String[] rawEventArgs;
        public List<ScriptEvent> matches = new ArrayList<ScriptEvent>();
        public TagContext context;

        public String rawEventArgAt(int index) {
            return index < this.rawEventArgs.length ? this.rawEventArgs[index] : "";
        }

        public String eventArgAt(int index) {
            return index < this.eventArgs.length ? this.eventArgs[index] : "";
        }

        public String eventArgLowerAt(int index) {
            return index < this.eventArgsLower.length ? this.eventArgsLower[index] : "";
        }

        public boolean checkSwitch(String key, String value) {
            String pathValue = this.switches.get(key);
            if (pathValue == null) {
                return true;
            }
            return CoreUtilities.toLowerCase(pathValue).equals(value);
        }

        public ScriptPath(ScriptContainer container, String event, String rawEventPath) {
            this.event = event;
            this.rawEventArgs = CoreUtilities.split(event, ' ').toArray(new String[0]);
            this.container = container;
            this.context = DenizenCore.getImplementation().getTagContext(container);
            ArrayList<String> eventLabel = new ArrayList<String>();
            for (String possible : CoreUtilities.split(event, ' ').toArray(new String[0])) {
                List<String> split = CoreUtilities.split(possible, ':', 2);
                if (split.size() > 1 && !split.get(0).equalsIgnoreCase("regex")) {
                    this.switches.put(CoreUtilities.toLowerCase(split.get(0)), split.get(1));
                    continue;
                }
                eventLabel.add(possible);
            }
            this.eventLower = CoreUtilities.toLowerCase(String.join((CharSequence)" ", eventLabel));
            this.eventArgs = eventLabel.toArray(new String[0]);
            this.eventArgsLower = CoreUtilities.split(this.eventLower, ' ').toArray(new String[0]);
            this.switch_cancelled = this.switches.containsKey("cancelled") ? Boolean.valueOf(this.switches.get("cancelled").equalsIgnoreCase("true")) : null;
            this.switch_ignoreCancelled = this.switches.containsKey("ignorecancelled") ? Boolean.valueOf(this.switches.get("ignorecancelled").equalsIgnoreCase("true")) : null;
            this.set = container.getSetFor("events." + rawEventPath);
        }

        public String toString() {
            return this.container.getName() + ".events.on " + this.event;
        }
    }

    public static class StatData {
        public long fires = 0L;
        public long scriptFires = 0L;
        public long nanoTimes = 0L;
    }
}

