/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ArgumentHelper {
    private static String DIGITS = "0123456789";
    private static String PREFIXES = "+-";
    private static String DOUBLE_CHARS = ".eE-";
    private static AsciiMatcher INTEGER_MATCHER = new AsciiMatcher(DIGITS + PREFIXES);
    private static AsciiMatcher DOUBLE_AFTERFIRST_MATCHER = new AsciiMatcher(DIGITS + DOUBLE_CHARS);

    public static List<Argument> interpret(ScriptEntry entry, List<String> args) {
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (String string : args) {
            Argument newArg = new Argument(string);
            newArg.scriptEntry = entry;
            arg_list.add(newArg);
        }
        return arg_list;
    }

    public static String[] buildArgs(String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        stringArgs = stringArgs.trim();
        stringArgs = stringArgs.replace('\r', ' ').replace('\n', ' ');
        ArrayList<String> matchList = new ArrayList<String>(stringArgs.length() / 7);
        int start = 0;
        int len = stringArgs.length();
        char currentQuote = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = stringArgs.charAt(i);
            if (c == ' ' && currentQuote == '\u0000') {
                if (i > start) {
                    matchList.add(stringArgs.substring(start, i));
                }
                start = i + 1;
                continue;
            }
            if (c != '\"' && c != '\'') continue;
            if (currentQuote == '\u0000') {
                if (i - 1 >= 0 && stringArgs.charAt(i - 1) != ' ') continue;
                currentQuote = c;
                start = i + 1;
                continue;
            }
            if (currentQuote != c || i + 1 < len && stringArgs.charAt(i + 1) != ' ') continue;
            currentQuote = '\u0000';
            if (i >= start) {
                matchList.add(stringArgs.substring(start, i));
            }
            start = ++i + 1;
        }
        if (start < len) {
            matchList.add(stringArgs.substring(start));
        }
        if (Debug.showScriptBuilder) {
            Debug.log("Constructed args: " + Arrays.toString(matchList.toArray()));
        }
        return matchList.toArray(new String[0]);
    }

    public static String debugObj(String prefix, Object value) {
        return "<G>" + prefix + "='<Y>" + (value != null ? (value instanceof ObjectTag ? ((ObjectTag)value).debuggable() : value.toString()) : "null") + "<G>'  ";
    }

    public static <T extends ObjectTag> String debugList(String prefix, Collection<T> objects) {
        if (objects == null) {
            return ArgumentHelper.debugObj(prefix, null);
        }
        StringBuilder sb = new StringBuilder();
        for (ObjectTag obj : objects) {
            sb.append(obj.debuggable()).append("<G>, ");
        }
        if (sb.length() == 0) {
            return ArgumentHelper.debugObj(prefix, sb);
        }
        return ArgumentHelper.debugObj(prefix, "[" + sb.substring(0, sb.length() - "<G>, ".length()) + "<Y>]");
    }

    public static String debugUniqueObj(String prefix, String id, Object value) {
        return "<G>" + prefix + "='<A>" + id + "<Y>(" + (value != null ? value.toString() : "null") + ")<G>'  ";
    }

    public static boolean matchesDouble(String arg) {
        if (arg.length() == 0) {
            return false;
        }
        if (!INTEGER_MATCHER.isMatch(arg.charAt(0))) {
            return false;
        }
        for (int i = 1; i < arg.length(); ++i) {
            if (DOUBLE_AFTERFIRST_MATCHER.isMatch(arg.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesInteger(String arg) {
        return ArgumentHelper.matchesDouble(arg) && INTEGER_MATCHER.isOnlyMatches(arg);
    }
}

