/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class CommandExecutor {
    public static ScriptQueue currentQueue;

    public static void debugSingleExecution(ScriptEntry scriptEntry) {
        StringBuilder output = new StringBuilder();
        output.append("<G>(line ").append(scriptEntry.internal.lineNumber).append(")<W> ");
        output.append(scriptEntry.getCommandName());
        if (scriptEntry.getOriginalArguments() == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Original Arguments null for " + scriptEntry.getCommandName());
        } else {
            for (String arg : scriptEntry.getOriginalArguments()) {
                if (CoreUtilities.contains(arg, ' ')) {
                    output.append(" \"").append(arg).append("\"");
                    continue;
                }
                output.append(" ").append(arg);
            }
        }
        DenizenCore.getImplementation().debugQueueExecute(scriptEntry, scriptEntry.getResidingQueue().debugId, output.toString());
    }

    public boolean execute(ScriptEntry scriptEntry) {
        if (scriptEntry.dbCallShouldDebug()) {
            CommandExecutor.debugSingleExecution(scriptEntry);
        }
        TagManager.recentTagError = false;
        AbstractCommand command = scriptEntry.internal.actualCommand;
        currentQueue = scriptEntry.getResidingQueue();
        String saveName = null;
        try {
            scriptEntry.generateAHArgs();
            TagContext context = scriptEntry.getContext();
            for (Argument arg : scriptEntry.internal.preprocArgs) {
                if (DenizenCore.getImplementation().handleCustomArgs(scriptEntry, arg, false) || !arg.matchesPrefix("save")) continue;
                saveName = TagManager.tag(arg.getValue(), context);
                if (!scriptEntry.dbCallShouldDebug()) continue;
                Debug.echoDebug((Debuggable)scriptEntry, "...remembering this script entry as '" + saveName + "'!");
            }
            if (scriptEntry.internal.actualCommand.shouldPreParse()) {
                TagManager.fillArgumentsObjects(scriptEntry.processed_arguments, scriptEntry.internal.args_ref, scriptEntry.aHArgs, context, scriptEntry.internal.processArgs);
            }
            command.parseArgs(scriptEntry);
            command.execute(scriptEntry);
            if (saveName != null) {
                scriptEntry.getResidingQueue().holdScriptEntry(saveName, scriptEntry);
            }
            currentQueue = null;
            return true;
        }
        catch (InvalidArgumentsException e) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Woah! Invalid arguments were specified!");
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                Debug.log("+> MESSAGE follows: '" + e.getMessage() + "'");
            }
            Debug.log("Usage: " + command.getUsageHint());
            Debug.log("(Attempted: " + scriptEntry.toString() + ")");
            Debug.echoDebug((Debuggable)scriptEntry, Debug.DebugElement.Footer);
            scriptEntry.setFinished(true);
            currentQueue = null;
            return false;
        }
        catch (Exception e) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Woah! An exception has been called with this command!");
            Debug.echoError(scriptEntry.getResidingQueue(), e);
            Debug.log("(Attempted: " + scriptEntry.toString() + ")");
            Debug.echoDebug((Debuggable)scriptEntry, Debug.DebugElement.Footer);
            scriptEntry.setFinished(true);
            currentQueue = null;
            return false;
        }
    }
}

