/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class WebGetCommand
extends AbstractCommand
implements Holdable {
    public WebGetCommand() {
        this.setName("webget");
        this.setSyntax("webget [<url>] (post:<data>) (headers:<header>/<value>|...) (timeout:<duration>/{10s}) (savefile:<path>)");
        this.setRequiredArguments(1, 5);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("url")) {
                scriptEntry.addObject("url", new ElementTag(arg.raw_value));
                continue;
            }
            if (!scriptEntry.hasObject("post") && arg.matchesPrefix("post")) {
                scriptEntry.addObject("post", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("timeout") && arg.matchesPrefix("timeout", "t") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("timeout", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("headers") && arg.matchesPrefix("headers")) {
                scriptEntry.addObject("headers", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("savefile") && arg.matchesPrefix("savefile")) {
                scriptEntry.addObject("savefile", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("url")) {
            throw new InvalidArgumentsException("Must have a valid URL!");
        }
        ElementTag url = scriptEntry.getElement("url");
        if (!url.asString().startsWith("http://") && !url.asString().startsWith("https://")) {
            throw new InvalidArgumentsException("Must have a valid (HTTP/HTTPS) URL! Attempted: " + url.asString());
        }
        scriptEntry.defaultObject("timeout", new DurationTag(10));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        if (!DenizenCore.getImplementation().allowedToWebget()) {
            Debug.echoError(scriptEntry.getResidingQueue(), "WebGet disabled by config!");
            return;
        }
        final ElementTag url = scriptEntry.getElement("url");
        final ElementTag postData = scriptEntry.getElement("post");
        final DurationTag timeout = (DurationTag)scriptEntry.getObjectTag("timeout");
        final ListTag headers = (ListTag)scriptEntry.getObjectTag("headers");
        final ElementTag saveFile = scriptEntry.getElement("savefile");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), url.debug() + (postData != null ? postData.debug() : "") + (timeout != null ? timeout.debug() : "") + (saveFile != null ? saveFile.debug() : "") + (headers != null ? headers.debug() : ""));
        }
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                WebGetCommand.this.webGet(scriptEntry, postData, url, timeout, headers, saveFile);
            }
        });
        thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webGet(final ScriptEntry scriptEntry, ElementTag postData, ElementTag urlp, DurationTag timeout, ListTag headers, final ElementTag saveFile) {
        BufferedReader buffIn = null;
        try {
            URL url = new URL(urlp.asString().replace(" ", "%20"));
            final HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            if (postData != null) {
                uc.setRequestMethod("POST");
            }
            if (headers != null) {
                for (String str : headers) {
                    int ind = str.indexOf(47);
                    if (ind <= 0) continue;
                    uc.setRequestProperty(str.substring(0, ind), str.substring(ind + 1));
                }
            }
            uc.setConnectTimeout((int)timeout.getMillis());
            uc.connect();
            if (postData != null) {
                uc.getOutputStream().write(postData.asString().getBytes(StandardCharsets.UTF_8));
            }
            final StringBuilder sb = new StringBuilder();
            if (saveFile != null) {
                File file = new File(saveFile.asString());
                if (!DenizenCore.getImplementation().canWriteToFile(file)) {
                    Debug.echoError("Cannot write to that file, as dangerous file paths have been disabled in the Denizen config.");
                } else {
                    int len;
                    InputStream in = uc.getInputStream();
                    FileOutputStream fout = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer)) > 0) {
                        fout.write(buffer, 0, len);
                    }
                    fout.flush();
                    fout.close();
                }
            } else {
                buffIn = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                try {
                    String temp;
                    while ((temp = buffIn.readLine()) != null) {
                        sb.append(temp).append("\n");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                buffIn.close();
                buffIn = null;
            }
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    try {
                        scriptEntry.addObject("failed", new ElementTag(uc.getResponseCode() == 200 ? "false" : "true"));
                    }
                    catch (Exception e) {
                        Debug.echoError(e);
                    }
                    if (saveFile == null) {
                        scriptEntry.addObject("result", new ElementTag(sb.toString()));
                    }
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
        catch (Exception e) {
            Debug.echoError(e);
            try {
                DenizenCore.schedule(new Schedulable(){

                    @Override
                    public boolean tick(float seconds) {
                        scriptEntry.addObject("failed", new ElementTag("true"));
                        scriptEntry.setFinished(true);
                        return false;
                    }
                });
            }
            catch (Exception e2) {
                Debug.echoError(e2);
            }
        }
        finally {
            try {
                if (buffIn != null) {
                    buffIn.close();
                }
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
    }
}

