/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.ContextTagBase;
import com.denizenscript.denizencore.tags.core.DefinitionTagBase;
import com.denizenscript.denizencore.tags.core.DurationTagBase;
import com.denizenscript.denizencore.tags.core.ElementTagBase;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.tags.core.ListTagBase;
import com.denizenscript.denizencore.tags.core.ProcedureScriptTagBase;
import com.denizenscript.denizencore.tags.core.QueueTagBase;
import com.denizenscript.denizencore.tags.core.ScriptTagBase;
import com.denizenscript.denizencore.tags.core.TernaryTagBase;
import com.denizenscript.denizencore.tags.core.UtilTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

public class TagManager {
    public static HashMap<String, TagRunnable.RootForm> handlers = new HashMap();
    public static HashSet<String> properTagBases = new HashSet();
    public static boolean isInTag = false;
    public static boolean recentTagError = true;
    public static Pattern OBJECTTAG_CONFUSION_PATTERN = Pattern.compile("<\\w+tag[\\[.>].*", 2);
    static HashMap<String, List<ParseableTagPiece>> preCalced = new HashMap();

    public void registerCoreTags() {
        new DurationTagBase();
        new ElementTagBase();
        new ListTagBase();
        new QueueTagBase();
        new ScriptTagBase();
        new ContextTagBase();
        new DefinitionTagBase();
        new EscapeTagBase();
        new ProcedureScriptTagBase();
        new TernaryTagBase();
        new UtilTagBase();
    }

    public static void registerTagHandler(TagRunnable.RootForm run, String ... names) {
        properTagBases.add(names[0]);
        if (names.length == 1) {
            run.name = names[0];
            handlers.put(run.name, run);
        } else {
            for (String name : names) {
                TagRunnable.RootForm rtemp = run.clone();
                rtemp.name = name;
                handlers.put(rtemp.name, rtemp);
            }
        }
    }

    public static void fireEvent(ReplaceableTagEvent event) {
        TagRunnable.RootForm handler;
        if (Debug.verbose) {
            Debug.log("Tag fire: " + event.raw_tag + ", " + event.getAttributes().attributes[0].rawKey.contains("@") + ", " + event.hasAlternative() + "...");
        }
        if ((handler = event.mainRef.baseHandler) != null) {
            try {
                if (Debug.verbose) {
                    Debug.log("Tag handle: " + event.raw_tag + " " + handler.name + "...");
                }
                handler.run(event);
                if (event.replaced()) {
                    if (Debug.verbose) {
                        Debug.log("Tag handle success: " + event.getReplaced());
                    }
                    return;
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        } else if (!event.hasAlternative()) {
            Debug.echoError("No tag-base handler for '" + event.getName() + "'.");
        }
        if (Debug.verbose) {
            Debug.log("Tag unhandled!");
        }
    }

    public static void fetchObject(ReplaceableTagEvent event) {
        block8: {
            String object_type = CoreUtilities.toLowerCase(CoreUtilities.split(event.getAttributes().attributes[0].rawKey, '@').get(0));
            Class object_class = ObjectFetcher.getObjectClass(object_type);
            if (object_class == null) {
                if (!event.hasAlternative()) {
                    Debug.echoError("Invalid object type! Could not fetch '" + object_type + "'!");
                    event.setReplaced("null");
                }
                return;
            }
            try {
                String tagObjectFull;
                String string = tagObjectFull = event.hasNameContext() ? event.getAttributes().attributes[0].rawKey + '[' + event.getNameContext() + ']' : event.getAttributes().attributes[0].rawKey;
                if (!ObjectFetcher.checkMatch(object_class, tagObjectFull)) {
                    if (!event.hasAlternative()) {
                        Debug.echoDebug((Debuggable)event.getScriptEntry(), "Returning null. '" + event.getAttributes().attributes[0].rawKey + "' is an invalid " + object_class.getSimpleName() + ".");
                        event.setReplaced("null");
                    }
                    return;
                }
                Object arg = ObjectFetcher.getObjectFrom(object_class, tagObjectFull, event.getContext());
                if (arg == null) {
                    if (!event.hasAlternative()) {
                        Debug.echoError((event.hasNameContext() ? event.getAttributes().attributes[0].rawKey + '[' + event.getNameContext() + ']' : event.getAttributes().attributes[0].rawKey) + " is an invalid ObjectTag!");
                        event.setReplaced("null");
                    }
                    return;
                }
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(CoreUtilities.autoAttrib(arg, attribute.fulfill(1)));
            }
            catch (Exception e) {
                Debug.echoError("Uh oh! Report this to the Denizen developers! Err: TagManagerObjectReflection");
                Debug.echoError(e);
                if (event.hasAlternative()) break block8;
                event.setReplaced("null");
            }
        }
    }

    public static void executeWithTimeLimit(final ReplaceableTagEvent event, int seconds) {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    DenizenCore.getImplementation().preTagExecute();
                    if (isInTag) {
                        TagManager.fireEvent(event);
                    } else {
                        isInTag = true;
                        TagManager.fireEvent(event);
                        isInTag = false;
                    }
                }
                finally {
                    DenizenCore.getImplementation().postTagExecute();
                }
            }
        });
        executor.shutdown();
        try {
            future.get(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Debug.echoError("Tag filling was interrupted!");
        }
        catch (ExecutionException e) {
            Debug.echoError(e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            Debug.echoError("Tag filling timed out!");
        }
        executor.shutdownNow();
    }

    public static String readSingleTag(String str, TagContext context) {
        ReplaceableTagEvent event = new ReplaceableTagEvent(str, context);
        return TagManager.readSingleTagObject(context, event).toString();
    }

    public static ObjectTag readSingleTagObject(ParseableTagPiece tag, TagContext context) {
        ReplaceableTagEvent event = new ReplaceableTagEvent(tag.tagData, tag.content, context);
        return TagManager.readSingleTagObject(context, event);
    }

    public static ObjectTag readSingleTagObject(TagContext context, ReplaceableTagEvent event) {
        int tT = DenizenCore.getImplementation().getTagTimeout();
        if (Debug.verbose) {
            Debug.log("Tag read: " + event.raw_tag + ", " + tT + "...");
        }
        if (tT <= 0 || isInTag || !DenizenCore.getImplementation().shouldDebug(context) && !DenizenCore.getImplementation().tagTimeoutWhenSilent()) {
            TagManager.fireEvent(event);
        } else {
            TagManager.executeWithTimeLimit(event, tT);
        }
        if (!event.replaced() && event.hasAlternative()) {
            event.setReplacedObject(event.getAlternative());
        }
        if (context.debug && event.replaced()) {
            DenizenCore.getImplementation().debugTagFill(context, event.toString(), event.getReplacedObj().debuggable());
        }
        if (!event.replaced()) {
            ScriptQueue queue = context.entry != null ? context.entry.getResidingQueue() : null;
            String tagStr = "<" + event.toString() + ">";
            Debug.echoError(queue, "Tag " + tagStr + " is invalid!");
            recentTagError = true;
            if (OBJECTTAG_CONFUSION_PATTERN.matcher(tagStr).matches()) {
                Debug.echoError(queue, "'ObjectTag' notation is for documentation purposes, and not to be used literally. An actual object must be inserted instead. If confused, join our Discord at https://discord.gg/Q6pZGSR to ask for help!");
            }
            return new ElementTag(event.raw_tag);
        }
        return event.getReplacedObj();
    }

    public static ObjectTag parseChainObject(List<ParseableTagPiece> pieces, TagContext context) {
        if (Debug.verbose) {
            Debug.log("Tag parse chain: " + pieces + "...");
            try {
                throw new RuntimeException("Stack");
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
        }
        if (pieces.size() < 2) {
            if (pieces.isEmpty()) {
                return new ElementTag("");
            }
            ParseableTagPiece pzero = pieces.get(0);
            if (pzero.isError) {
                Debug.echoError(context.entry != null ? context.entry.getResidingQueue() : null, pzero.content);
            } else {
                if (pzero.isTag) {
                    return TagManager.readSingleTagObject(pzero, context);
                }
                if (pzero.objResult != null) {
                    return pzero.objResult;
                }
            }
            return new ElementTag(pieces.get((int)0).content);
        }
        StringBuilder helpy = new StringBuilder();
        for (int i = 0; i < pieces.size(); ++i) {
            ParseableTagPiece p = pieces.get(i);
            if (p.isError) {
                Debug.echoError(context.entry != null ? context.entry.getResidingQueue() : null, p.content);
                continue;
            }
            if (p.isTag) {
                helpy.append(TagManager.readSingleTagObject(p, context).toString());
                continue;
            }
            if (p.objResult != null) {
                helpy.append(p.objResult.toString());
                continue;
            }
            helpy.append(p.content);
        }
        return new ElementTag(helpy.toString());
    }

    public static String tag(String arg, TagContext context) {
        return TagManager.tagObject(arg, context).toString();
    }

    public static List<ParseableTagPiece> dupChain(List<ParseableTagPiece> chain) {
        ArrayList<ParseableTagPiece> newPieces = new ArrayList<ParseableTagPiece>(chain.size());
        for (ParseableTagPiece piece : chain) {
            newPieces.add(piece.duplicate());
        }
        return newPieces;
    }

    public static List<ParseableTagPiece> genChain(String arg, TagContext context) {
        if (arg == null) {
            return null;
        }
        List<ParseableTagPiece> pieces = preCalced.get(arg);
        if (pieces != null) {
            return pieces;
        }
        pieces = new ArrayList<ParseableTagPiece>(1);
        if (arg.indexOf(62) == -1 || arg.length() < 3) {
            ParseableTagPiece txt = new ParseableTagPiece();
            txt.content = arg;
            pieces.add(txt);
            return pieces;
        }
        int[] positions = new int[2];
        positions[0] = -1;
        TagManager.locateTag(arg, positions);
        if (positions[0] == -1) {
            ParseableTagPiece txt = new ParseableTagPiece();
            txt.content = arg;
            pieces.add(txt);
            return pieces;
        }
        String orig = arg;
        while (positions[0] != -1) {
            ParseableTagPiece preText = null;
            if (positions[0] > 0) {
                preText = new ParseableTagPiece();
                preText.content = arg.substring(0, positions[0]);
                pieces.add(preText);
            }
            String tagToProc = arg.substring(positions[0] + 1, positions[1]);
            ParseableTagPiece midTag = new ParseableTagPiece();
            midTag.content = tagToProc;
            midTag.isTag = true;
            midTag.tagData = new ReplaceableTagEvent((String)tagToProc, (TagContext)context).mainRef;
            pieces.add(midTag);
            if (Debug.verbose) {
                Debug.log("Tag: " + (preText == null ? "<null>" : preText.content) + " ||| " + midTag.content);
            }
            arg = arg.substring(positions[1] + 1);
            TagManager.locateTag(arg, positions);
        }
        if (arg.indexOf(60) != -1) {
            ParseableTagPiece errorNote = new ParseableTagPiece();
            errorNote.isError = true;
            errorNote.content = "Potential issue: inconsistent tag marks in command! (issue snippet: " + arg + "; from: " + orig + ")";
            pieces.add(errorNote);
        }
        if (arg.length() > 0) {
            ParseableTagPiece postText = new ParseableTagPiece();
            postText.content = arg;
            pieces.add(postText);
        }
        if (Debug.verbose) {
            Debug.log("Tag chainify complete: " + arg);
        }
        return pieces;
    }

    public static ObjectTag tagObject(String arg, TagContext context) {
        return TagManager.parseChainObject(TagManager.genChain(arg, context), context);
    }

    public static int findColonNotTagNorSpace(String arg) {
        if (arg.indexOf(58) == -1) {
            return -1;
        }
        char[] arr = arg.toCharArray();
        int bracks = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '<') {
                ++bracks;
                continue;
            }
            if (arr[i] == '>') {
                --bracks;
                continue;
            }
            if (arr[i] == ':' && bracks == 0) {
                return i;
            }
            if (arr[i] != ' ' || bracks != 0) continue;
            return -1;
        }
        return -1;
    }

    private static void locateTag(String arg, int[] holder) {
        int first;
        holder[0] = first = arg.indexOf(60);
        if (first == -1) {
            return;
        }
        int len = arg.length();
        if (first + 1 < len && arg.charAt(first + 1) == '-') {
            TagManager.locateTag(arg.substring(0, first) + '\u0001' + arg.substring(first + 1), holder);
            return;
        }
        int bracks = 1;
        for (int i = first + 1; i < len; ++i) {
            if (arg.charAt(i) == '<') {
                ++bracks;
                continue;
            }
            if (arg.charAt(i) != '>' || --bracks != 0) continue;
            holder[1] = i;
            return;
        }
        holder[0] = -1;
    }

    public static void fillArgumentsObjects(List<ObjectTag> args, List<ScriptEntry.InternalArgument> pieceHelp, List<Argument> aHArgs, TagContext context, int[] targets) {
        if (Debug.verbose) {
            Debug.log("Fill argument objects: " + args + ", " + targets.length + "...");
        }
        for (int argId : targets) {
            Argument aharg = aHArgs.get(argId);
            ScriptEntry.InternalArgument piece = pieceHelp.get(argId);
            if (piece.prefix != null) {
                if (piece.prefix.aHArg.needsFill) {
                    aharg.prefix = TagManager.parseChainObject(piece.prefix.value, context).toString();
                    aharg.lower_prefix = CoreUtilities.toLowerCase(aharg.prefix);
                }
                if (aharg.needsFill) {
                    aharg.object = TagManager.parseChainObject(piece.value, context);
                }
                String fullx = aharg.prefix + ":" + aharg.object.toString();
                args.set(argId, new ElementTag(fullx));
                continue;
            }
            ObjectTag created = TagManager.parseChainObject(piece.value, context);
            args.set(argId, created);
            aharg.object = created;
            aharg.prefix = null;
            aharg.lower_prefix = null;
        }
    }

    public static class ParseableTagPiece {
        public String content;
        public ObjectTag objResult = null;
        public boolean isTag = false;
        public boolean isError = false;
        public ReplaceableTagEvent.ReferenceData tagData = null;

        public String toString() {
            return "(" + this.isError + ", " + this.isTag + ", " + (this.isTag ? this.tagData.rawTag : "") + ", " + this.content + "," + this.objResult + ")";
        }

        public ParseableTagPiece duplicate() {
            ParseableTagPiece newPiece = new ParseableTagPiece();
            newPiece.content = this.content;
            newPiece.objResult = this.objResult;
            newPiece.isTag = this.isTag;
            newPiece.isError = this.isError;
            newPiece.tagData = this.tagData;
            return newPiece;
        }
    }
}

