/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.NaturalOrderComparator;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ListTag
extends ArrayList<String>
implements ObjectTag {
    public final ArrayList<ObjectTag> objectForms;
    private String prefix = "List";
    public String flag = null;
    public static ObjectTagProcessor<ListTag> tagProcessor = new ObjectTagProcessor();

    @Override
    public boolean add(String addMe) {
        this.objectForms.add(new ElementTag(addMe));
        return super.add(addMe);
    }

    @Override
    public void add(int index, String addMe) {
        this.objectForms.add(index, new ElementTag(addMe));
        super.add(index, addMe);
    }

    @Override
    public boolean addAll(Collection<? extends String> addMe) {
        for (String string : addMe) {
            this.add(string);
        }
        return !addMe.isEmpty();
    }

    @Override
    public String remove(int index) {
        this.objectForms.remove(index);
        return (String)super.remove(index);
    }

    @Override
    public boolean remove(Object key) {
        int ind = super.indexOf(key);
        if (ind < 0 || ind >= this.size()) {
            return false;
        }
        this.remove(ind);
        return true;
    }

    public boolean addAll(ListTag inp) {
        this.objectForms.addAll(inp.objectForms);
        return super.addAll(inp);
    }

    public boolean addObject(ObjectTag obj) {
        this.objectForms.add(obj);
        return super.add(obj.toString());
    }

    public void addObject(int index, ObjectTag obj) {
        this.objectForms.add(index, obj);
        super.add(index, obj.toString());
    }

    public void setObject(int index, ObjectTag obj) {
        this.objectForms.set(index, obj);
        super.set(index, obj.toString());
    }

    public ObjectTag getObject(int id) {
        return this.objectForms.get(id);
    }

    @Deprecated
    public static ListTag valueOf(String string) {
        return ListTag.valueOf(string, null);
    }

    @Fetchable(value="li")
    public static ListTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        ListTag list = DenizenCore.getImplementation().valueOfFlagListTag(string);
        if (list != null) {
            return list;
        }
        return new ListTag(string.startsWith("li@") ? string.substring(3) : string, context);
    }

    public static ListTag getListFor(ObjectTag inp, TagContext context) {
        return inp instanceof ListTag ? (ListTag)inp : ListTag.valueOf(inp.toString(), context);
    }

    public static boolean matches(String arg) {
        boolean flag = DenizenCore.getImplementation().matchesFlagListTag(arg);
        return flag || arg.contains("|") || arg.startsWith("li@");
    }

    @Override
    public ObjectTag duplicate() {
        ArrayList<ObjectTag> objs = new ArrayList<ObjectTag>(this.size());
        for (ObjectTag obj : this.objectForms) {
            objs.add(obj == null ? null : obj.duplicate());
        }
        return new ListTag((Collection<? extends ObjectTag>)objs);
    }

    public ListTag(Collection<? extends ObjectTag> objectTagList) {
        this.objectForms = new ArrayList<ObjectTag>(objectTagList);
        for (ObjectTag objectTag : objectTagList) {
            super.add(objectTag.identify());
        }
    }

    public ListTag(ObjectTag ... objects) {
        this((Collection<? extends ObjectTag>)Arrays.asList(objects));
    }

    public ListTag() {
        this.objectForms = new ArrayList();
    }

    public ListTag(String items) {
        this(items, null);
    }

    public ListTag(String items, TagContext context) {
        if (items != null && items.length() > 0) {
            int brackets = 0;
            int start = 0;
            for (int i = 0; i < items.length(); ++i) {
                char chr = items.charAt(i);
                if (chr == '[') {
                    ++brackets;
                    continue;
                }
                if (chr == ']') {
                    if (brackets <= 0) continue;
                    --brackets;
                    continue;
                }
                if (brackets != 0 || chr != '|') continue;
                super.add(items.substring(start, i));
                start = i + 1;
            }
            if (start < items.length()) {
                super.add(items.substring(start));
            }
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(ObjectFetcher.pickObjectFor(str, context));
        }
    }

    public ListTag(String flag, boolean is_flag, List<String> flag_contents) {
        if (is_flag) {
            this.flag = flag;
        }
        for (String it : flag_contents) {
            super.add(it);
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag(ListTag input) {
        this.objectForms = new ArrayList<ObjectTag>(input.objectForms);
        super.ensureCapacity(input.size());
        for (String str : input) {
            super.add(str);
        }
    }

    public ListTag(List<String> items) {
        if (items != null) {
            for (String it : items) {
                super.add(it);
            }
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag(Set<?> items) {
        this.objectForms = new ArrayList(items.size());
        if (items != null) {
            for (Object o : items) {
                String strd = o.toString();
                super.add(strd);
                if (o instanceof ObjectTag) {
                    this.objectForms.add((ObjectTag)o);
                    continue;
                }
                this.objectForms.add(new ElementTag(strd));
            }
        }
    }

    public ListTag(List<String> items, String prefix) {
        for (String element : items) {
            super.add(prefix + element);
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag addObjects(List<ObjectTag> ObjectTags) {
        for (ObjectTag obj : ObjectTags) {
            this.addObject(obj);
        }
        return this;
    }

    public boolean containsObjectsFrom(Class<? extends ObjectTag> dClass) {
        for (ObjectTag testable : this.objectForms) {
            if (!CoreUtilities.canPossiblyBeType(testable, dClass)) continue;
            return true;
        }
        return false;
    }

    public List<String> filter(Enum[] values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (String string : this) {
            for (Enum value : values) {
                if (!value.name().equalsIgnoreCase(string)) continue;
                list.add(string);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, ScriptEntry entry) {
        return this.filter(dClass, entry == null ? CoreUtilities.basicContext : entry.entryData.getTagContext(), true);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, Debuggable debugger, boolean showFailure) {
        TagContext context = DenizenCore.getImplementation().getTagContext((ScriptEntry)null);
        context.debug = debugger.shouldDebug();
        return this.filter(dClass, context, showFailure);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, TagContext context) {
        return this.filter(dClass, context, context == null || context.debug);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, TagContext context, boolean showFailure) {
        ArrayList<T> results = new ArrayList<T>(this.objectForms.size());
        for (ObjectTag obj : this.objectForms) {
            try {
                if (CoreUtilities.canPossiblyBeType(obj, dClass)) {
                    T object = CoreUtilities.asType(obj, dClass, context);
                    if (object != null) {
                        results.add(object);
                        continue;
                    }
                    if (!showFailure) continue;
                    Debug.echoError("Cannot process list-entry '" + obj + "' as type '" + dClass.getSimpleName() + "' (conversion returned null).");
                    continue;
                }
                if (!showFailure) continue;
                Debug.echoError("Cannot process list-entry '" + obj + "' as type '" + dClass.getSimpleName() + "' (does not match expected type).");
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        return results;
    }

    public ListTag deduplicate() {
        ListTag list = new ListTag();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String entry = (String)this.get(i);
            boolean duplicate = false;
            for (int x = 0; x < i; ++x) {
                if (!((String)this.get(x)).equalsIgnoreCase(entry)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            list.addObject(this.objectForms.get(i));
        }
        return list;
    }

    @Override
    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ListTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder debugText = new StringBuilder();
        debugText.append("<G>li@<Y> ");
        for (ObjectTag item : this.objectForms) {
            debugText.append(item.debuggable()).append(" <G>|<Y> ");
        }
        return debugText.substring(0, debugText.length() - " <G>|<Y> ".length());
    }

    @Override
    public boolean isUnique() {
        return this.flag != null;
    }

    @Override
    public String getObjectType() {
        return "List";
    }

    @Override
    public String identify() {
        if (this.flag != null && this.size() == 1) {
            return (String)this.get(0);
        }
        return this.identifyList();
    }

    public String identifyList() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder output = new StringBuilder();
        output.append("li@");
        for (String item : this) {
            output.append(item).append('|');
        }
        return output.substring(0, output.length() - 1);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    private static String parseString(ListTag obj, String spacer) {
        StringBuilder dScriptArg = new StringBuilder();
        for (String item : obj) {
            dScriptArg.append(item);
            dScriptArg.append(spacer);
        }
        return dScriptArg.toString().substring(0, dScriptArg.length() - spacer.length());
    }

    public static void registerTags() {
        ListTag.registerTag("combine", (attribute, object) -> {
            ListTag output = new ListTag();
            for (ObjectTag obj : object.objectForms) {
                output.addObjects(ListTag.getListFor((ObjectTag)obj, (TagContext)attribute.context).objectForms);
            }
            return output;
        }, new String[0]);
        ListTag.registerTag("space_separated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, " "));
        }, "as_string", "asstring");
        ListTag.registerTag("separated_by", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            String input = attribute.getContext(1);
            return new ElementTag(ListTag.parseString(object, input));
        }, new String[0]);
        ListTag.registerTag("comma_separated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, ", "));
        }, "ascslist", "as_cslist");
        ListTag.registerTag("unseparated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, ""));
        }, new String[0]);
        ListTag.registerTag("get_sub_items", (attribute, object) -> {
            int index = -1;
            if (ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                index = attribute.getIntContext(1) - 1;
            }
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            if (index < 0) {
                return null;
            }
            ListTag sub_list = new ListTag();
            for (String item : object) {
                String[] strings = item.split(Pattern.quote(split));
                if (strings.length > index) {
                    sub_list.add(strings[index]);
                    continue;
                }
                sub_list.add("null");
            }
            return sub_list;
        }, new String[0]);
        ListTag.registerTag("map_get", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            ListTag input = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            ListTag result = new ListTag();
            for (String key : input) {
                for (String item : object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[0].equalsIgnoreCase(key)) continue;
                    result.add(strings[1]);
                }
            }
            if (input.size() == 1 && result.size() == 1) {
                return new ElementTag((String)result.get(0));
            }
            if (input.size() > 1) {
                if (result.size() != input.size()) {
                    return null;
                }
                return result;
            }
            return null;
        }, new String[0]);
        ListTag.registerTag("map_find_key", (attribute, object) -> {
            String input = attribute.getContext(1);
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            for (String item : object) {
                String[] strings = item.split(Pattern.quote(split), 2);
                if (strings.length <= 1 || !strings[1].equalsIgnoreCase(input)) continue;
                return new ElementTag(strings[0]);
            }
            return null;
        }, new String[0]);
        ListTag.registerTag("size", (attribute, object) -> new ElementTag(object.size()), new String[0]);
        ListTag.registerTag("is_empty", (attribute, object) -> new ElementTag(object.isEmpty()), new String[0]);
        ListTag.registerTag("insert", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.insert[...] must have a value.");
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = attribute.getIntContext(2) - 1;
                if (index < 0) {
                    index = 0;
                }
                if (index > result.size()) {
                    index = result.size();
                }
                for (int i = 0; i < items.size(); ++i) {
                    result.addObject(index + i, items.getObject(i));
                }
                attribute.fulfill(1);
                return result;
            }
            Debug.echoError("The tag ListTag.insert[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        ListTag.registerTag("set", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.set[...] must have a value.");
                return null;
            }
            if (object.isEmpty()) {
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = attribute.getIntContext(2) - 1;
                if (index < 0) {
                    index = 0;
                }
                if (index > result.size() - 1) {
                    index = result.size() - 1;
                }
                attribute.fulfill(1);
                result.remove(index);
                for (int i = 0; i < items.size(); ++i) {
                    result.addObject(index + i, items.objectForms.get(i));
                }
                return result;
            }
            Debug.echoError("The tag ListTag.set[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        ListTag.registerTag("include", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.include[...] must have a value.");
                return null;
            }
            ListTag copy = new ListTag((ListTag)object);
            copy.addAll(ListTag.getListFor(attribute.getContextObject(1), attribute.context));
            return copy;
        }, new String[0]);
        ListTag.registerTag("exclude", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.exclude[...] must have a value.");
                return null;
            }
            ListTag exclusions = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            ListTag copy = new ListTag((ListTag)object);
            for (String exclusion : exclusions) {
                for (int i = 0; i < copy.size(); ++i) {
                    if (!((String)copy.get(i)).equalsIgnoreCase(exclusion)) continue;
                    copy.remove(i--);
                }
            }
            return copy;
        }, new String[0]);
        ListTag.registerTag("remove", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.remove[#] must have a value.");
                return null;
            }
            ListTag indices = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            ListTag copy = new ListTag((ListTag)object);
            for (String index : indices) {
                int remove = index.equalsIgnoreCase("last") ? copy.size() - 1 : (index.equalsIgnoreCase("first") ? 0 : new ElementTag(index).asInt() - 1);
                if (remove < 0 || remove >= copy.size()) continue;
                copy.set(remove, "\u0000");
            }
            for (int i = 0; i < copy.size(); ++i) {
                if (!((String)copy.get(i)).equals("\u0000")) continue;
                copy.remove(i--);
            }
            return copy;
        }, new String[0]);
        ListTag.registerTag("shared_contents", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.shared_contents[...] must have a value.");
                return null;
            }
            ListTag secondList = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            ListTag output = new ListTag();
            for (String val : object) {
                if (!secondList.containsCaseInsensitive(val) || output.containsCaseInsensitive(val)) continue;
                output.add(val);
            }
            return output;
        }, new String[0]);
        ListTag.registerTag("replace", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.replace[...] must have a value.");
                return null;
            }
            String replace = attribute.getContext(1);
            ObjectTag replacement = null;
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                replacement = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag list = new ListTag();
            if (replace.startsWith("regex:")) {
                String regex = replace.substring("regex:".length());
                Pattern tempPat = Pattern.compile(regex);
                for (int i = 0; i < object.size(); ++i) {
                    if (tempPat.matcher((CharSequence)object.get(i)).matches()) {
                        if (replacement == null) continue;
                        list.addObject(replacement);
                        continue;
                    }
                    list.addObject(object.getObject(i));
                }
            } else {
                String lower = CoreUtilities.toLowerCase(replace);
                for (int i = 0; i < object.size(); ++i) {
                    if (CoreUtilities.toLowerCase((String)object.get(i)).equals(lower)) {
                        if (replacement == null) continue;
                        list.addObject(replacement);
                        continue;
                    }
                    list.addObject(object.getObject(i));
                }
            }
            return list;
        }, new String[0]);
        ListTag.registerTag("reverse", (attribute, object) -> {
            ArrayList<ObjectTag> objs = new ArrayList<ObjectTag>(object.objectForms);
            Collections.reverse(objs);
            return new ListTag((Collection<? extends ObjectTag>)objs);
        }, new String[0]);
        ListTag.registerTag("deduplicate", (attribute, object) -> object.deduplicate(), new String[0]);
        TagRunnable.ObjectInterface<ListTag> getRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.get[...] must have a value.");
                return null;
            }
            if (object.isEmpty()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Can't get from an empty list.");
                }
                return null;
            }
            ListTag indices = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (indices.size() > 1) {
                ListTag results = new ListTag();
                for (String index : indices) {
                    int ind = Integer.parseInt(index);
                    if (ind <= 0 || ind > object.size()) continue;
                    results.add((String)object.get(ind - 1));
                }
                return results;
            }
            if (indices.size() > 0) {
                int index = Integer.parseInt((String)indices.get(0)) - 1;
                if (index >= object.size()) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Invalid list.get index.");
                    }
                    return null;
                }
                if (index < 0) {
                    index = 0;
                }
                if (attribute.startsWith("to", 2) && attribute.hasContext(2)) {
                    int index2 = attribute.getIntContext(2) - 1;
                    if (index2 >= object.size()) {
                        index2 = object.size() - 1;
                    }
                    if (index2 < 0) {
                        index2 = 0;
                    }
                    ListTag newList = new ListTag();
                    for (int i = index; i <= index2; ++i) {
                        newList.addObject(object.objectForms.get(i));
                    }
                    attribute.fulfill(1);
                    return newList;
                }
                return object.objectForms.get(index);
            }
            return null;
        };
        ListTag.registerTag("get", getRunnable, new String[0]);
        ListTag.registerTag("", getRunnable, new String[0]);
        ListTag.registerTag("find_all_partial", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.find_all_partial[...] must have a value.");
                return null;
            }
            String test = attribute.getContext(1).toUpperCase();
            ListTag positions = new ListTag();
            for (int i = 0; i < object.size(); ++i) {
                if (!((String)object.get(i)).toUpperCase().contains(test)) continue;
                positions.add(String.valueOf(i + 1));
            }
            return positions;
        }, new String[0]);
        ListTag.registerTag("find_all", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.find_all[...] must have a value.");
                return null;
            }
            ListTag positions = new ListTag();
            for (int i = 0; i < object.size(); ++i) {
                if (!((String)object.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                positions.add(String.valueOf(i + 1));
            }
            return positions;
        }, new String[0]);
        ListTag.registerTag("find_partial", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.find_partial[...] must have a value.");
                return null;
            }
            String test = attribute.getContext(1).toUpperCase();
            for (int i = 0; i < object.size(); ++i) {
                if (!((String)object.get(i)).toUpperCase().contains(test)) continue;
                return new ElementTag(i + 1);
            }
            return new ElementTag(-1);
        }, new String[0]);
        ListTag.registerTag("find", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.find[...] must have a value.");
                return null;
            }
            for (int i = 0; i < object.size(); ++i) {
                if (!((String)object.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                return new ElementTag(i + 1);
            }
            return new ElementTag(-1);
        }, new String[0]);
        ListTag.registerTag("count", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.count[...] must have a value.");
                return null;
            }
            String element = attribute.getContext(1);
            int count = 0;
            for (int i = 0; i < object.size(); ++i) {
                if (!((String)object.get(i)).equalsIgnoreCase(element)) continue;
                ++count;
            }
            return new ElementTag(count);
        }, new String[0]);
        ListTag.registerTag("sum", (attribute, object) -> {
            double sum = 0.0;
            for (String entry : object) {
                if (!ArgumentHelper.matchesDouble(entry)) continue;
                sum += Double.parseDouble(entry);
            }
            return new ElementTag(sum);
        }, new String[0]);
        ListTag.registerTag("average", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag(0);
            }
            double sum = 0.0;
            for (String entry : object) {
                if (!ArgumentHelper.matchesDouble(entry)) continue;
                sum += Double.parseDouble(entry);
            }
            return new ElementTag(sum / (double)object.size());
        }, new String[0]);
        ListTag.registerTag("first", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            return object.objectForms.get(0);
        }, new String[0]);
        ListTag.registerTag("last", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            return object.objectForms.get(object.size() - 1);
        }, new String[0]);
        ListTag.registerTag("lowest", (attribute, object) -> {
            String tag = null;
            if (attribute.hasContext(1)) {
                tag = attribute.getContext(1);
            }
            BigDecimal lowest = null;
            for (ObjectTag obj : object.objectForms) {
                String str;
                if (tag != null) {
                    obj = CoreUtilities.autoAttribTyped(obj, new Attribute(tag, attribute.getScriptEntry(), attribute.context));
                }
                if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                BigDecimal val = new ElementTag(str).asBigDecimal();
                if (lowest != null && lowest.compareTo(val) <= 0) continue;
                lowest = val;
            }
            if (lowest == null) {
                return null;
            }
            return new ElementTag(lowest);
        }, new String[0]);
        ListTag.registerTag("highest", (attribute, object) -> {
            String tag = null;
            if (attribute.hasContext(1)) {
                tag = attribute.getContext(1);
            }
            BigDecimal highest = null;
            for (ObjectTag obj : object.objectForms) {
                String str;
                if (tag != null) {
                    obj = CoreUtilities.autoAttribTyped(obj, new Attribute(tag, attribute.getScriptEntry(), attribute.context));
                }
                if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                BigDecimal val = new ElementTag(str).asBigDecimal();
                if (highest != null && highest.compareTo(val) >= 0) continue;
                highest = val;
            }
            if (highest == null) {
                return null;
            }
            return new ElementTag(highest);
        }, new String[0]);
        ListTag.registerTag("numerical", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            Collections.sort(sortable, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    double value = new ElementTag(o1).asDouble() - new ElementTag(o2).asDouble();
                    if (value == 0.0) {
                        return 0;
                    }
                    if (value > 0.0) {
                        return 1;
                    }
                    return -1;
                }
            });
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        ListTag.registerTag("alphanumeric", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            Collections.sort(sortable, new NaturalOrderComparator());
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        ListTag.registerTag("alphabetical", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            Collections.sort(sortable, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        ListTag.registerTag("sort_by_value", (attribute, object) -> {
            ListTag newlist = new ListTag((ListTag)object);
            final NaturalOrderComparator comparator = new NaturalOrderComparator();
            try {
                Collections.sort(newlist.objectForms, new Comparator<ObjectTag>(){

                    @Override
                    public int compare(ObjectTag o1, ObjectTag o2) {
                        ObjectTag or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                        ObjectTag or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                        return comparator.compare(or1, or2);
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)newlist.objectForms);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                return newlist;
            }
        }, new String[0]);
        ListTag.registerTag("sort_by_number", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("Sort_By_Number must have an input value.");
                return null;
            }
            ListTag newlist = new ListTag((ListTag)object);
            try {
                Collections.sort(newlist.objectForms, new Comparator<ObjectTag>(){

                    @Override
                    public int compare(ObjectTag o1, ObjectTag o2) {
                        ObjectTag or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                        ObjectTag or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                        try {
                            double r1 = Double.parseDouble(or1.toString());
                            double r2 = Double.parseDouble(or2.toString());
                            double value = r1 - r2;
                            if (value == 0.0) {
                                return 0;
                            }
                            if (value > 0.0) {
                                return 1;
                            }
                            return -1;
                        }
                        catch (NumberFormatException ex) {
                            attribute.echoError("Invalid non-numerical input to sort_by_number tag: " + or1.toString() + ", " + or2.toString());
                            return 0;
                        }
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)newlist.objectForms);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                return newlist;
            }
        }, new String[0]);
        ListTag.registerTag("sort", (attribute, object) -> {
            ListTag obj = new ListTag((ListTag)object);
            final ProcedureScriptContainer script = (ProcedureScriptContainer)ScriptTag.valueOf(attribute.getContext(1)).getContainer();
            if (script == null) {
                Debug.echoError("'" + attribute.getContext(1) + "' is not a valid procedure script!");
                return obj;
            }
            final ScriptEntry entry = attribute.getScriptEntry();
            ListTag context = new ListTag();
            if (attribute.startsWith("context", 2)) {
                context = ListTag.getListFor(attribute.getContextObject(2), attribute.context);
                attribute.fulfill(1);
            }
            final ListTag context_send = context;
            ArrayList<String> list = new ArrayList<String>(obj);
            try {
                Collections.sort(list, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        List<ScriptEntry> entries = script.getBaseEntries(entry == null ? DenizenCore.getImplementation().getEmptyScriptEntryData() : entry.entryData.clone());
                        if (entries.isEmpty()) {
                            return 0;
                        }
                        InstantQueue queue = new InstantQueue("LISTTAG_SORT");
                        queue.addEntries(entries);
                        int x = 1;
                        ListTag definitions = new ListTag();
                        definitions.add(o1);
                        definitions.add(o2);
                        definitions.addAll(context_send);
                        String[] definition_names = null;
                        try {
                            definition_names = script.getString("definitions").split("\\|");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        for (String definition : definitions) {
                            String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                            queue.addDefinition(name, definition);
                            Debug.echoDebug((Debuggable)entries.get(0), "Adding definition '" + name + "' as " + definition);
                            ++x;
                        }
                        queue.start();
                        int res = 0;
                        if (queue.determinations != null && queue.determinations.size() > 0) {
                            res = new ElementTag((String)queue.determinations.get(0)).asInt();
                        }
                        if (res < 0) {
                            return -1;
                        }
                        if (res > 0) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            catch (Exception e) {
                Debug.echoError("list.sort[...] tag failed - procedure returned unreasonable response - internal error: " + e.getMessage());
            }
            return new ListTag((List<String>)list);
        }, new String[0]);
        ListTag.registerTag("filter", (attribute, object) -> {
            String tag = attribute.getContext(1);
            boolean defaultValue = tag.endsWith("||true");
            if (defaultValue) {
                tag = tag.substring(0, tag.length() - "||true".length());
            }
            ListTag newlist = new ListTag();
            try {
                for (ObjectTag obj : object.objectForms) {
                    Attribute tempAttrib = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
                    tempAttrib.setHadAlternative(true);
                    ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                    if (!(objs == null ? defaultValue : CoreUtilities.toLowerCase(objs.toString()).equals("true"))) continue;
                    newlist.addObject(obj);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        ListTag.registerTag("parse", (attribute, object) -> {
            ListTag newlist = new ListTag();
            String tag = attribute.getContext(1);
            String defaultValue = "null";
            boolean fallback = false;
            if (tag.contains("||")) {
                int marks = 0;
                int lengthLimit = tag.length() - 1;
                for (int i = 0; i < lengthLimit; ++i) {
                    char c = tag.charAt(i);
                    if (c == '<') {
                        ++marks;
                        continue;
                    }
                    if (c == '>') {
                        --marks;
                        continue;
                    }
                    if (marks != 0 || c != '|' || tag.charAt(i + 1) != '|') continue;
                    fallback = true;
                    defaultValue = tag.substring(i + 2);
                    tag = tag.substring(0, i);
                    break;
                }
            }
            try {
                for (ObjectTag obj : object.objectForms) {
                    Attribute tempAttrib = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
                    tempAttrib.setHadAlternative(attribute.hasAlternative() || fallback);
                    ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                    if (objs == null) {
                        objs = new ElementTag(defaultValue);
                    }
                    newlist.addObject(objs);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        ListTag.registerTag("pad_left", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.pad_left[...] must have a value.");
                return null;
            }
            ObjectTag with = new ElementTag("");
            int length = attribute.getIntContext(1);
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag newList = new ListTag((ListTag)object);
            while (newList.size() < length) {
                newList.addObject(with);
            }
            return newList;
        }, new String[0]);
        ListTag.registerTag("pad_right", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.pad_right[...] must have a value.");
                return null;
            }
            ObjectTag with = new ElementTag("");
            int length = attribute.getIntContext(1);
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag newList = new ListTag((ListTag)object);
            while (newList.size() < length) {
                newList.addObject(with);
            }
            return newList;
        }, new String[0]);
        ListTag.registerTag("escape_contents", (attribute, object) -> {
            ListTag escaped = new ListTag();
            for (String entry : object) {
                escaped.add(EscapeTagBase.escape(entry));
            }
            return escaped;
        }, new String[0]);
        ListTag.registerTag("unescape_contents", (attribute, object) -> {
            ListTag escaped = new ListTag();
            for (String entry : object) {
                escaped.add(EscapeTagBase.unEscape(entry));
            }
            return escaped;
        }, new String[0]);
        ListTag.registerTag("contains_any_case_sensitive", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.contains_any_case_sensitive[...] must have a value.");
                return null;
            }
            ListTag list = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            boolean state = false;
            block0: for (String element : object) {
                for (String sub_element : list) {
                    if (!element.equals(sub_element)) continue;
                    state = true;
                    break block0;
                }
            }
            return new ElementTag(state);
        }, new String[0]);
        ListTag.registerTag("contains_any", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.contains_any[...] must have a value.");
                return null;
            }
            ListTag list = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            boolean state = false;
            block0: for (String element : object) {
                for (String sub_element : list) {
                    if (!element.equalsIgnoreCase(sub_element)) continue;
                    state = true;
                    break block0;
                }
            }
            return new ElementTag(state);
        }, new String[0]);
        ListTag.registerTag("contains_case_sensitive", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.contains_case_sensitive[...] must have a value.");
                return null;
            }
            boolean state = false;
            for (String element : object) {
                if (!element.equals(attribute.getContext(1))) continue;
                state = true;
                break;
            }
            return new ElementTag(state);
        }, new String[0]);
        ListTag.registerTag("contains", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.contains[...] must have a value.");
                return null;
            }
            ListTag needed = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            int gotten = 0;
            block0: for (String check : needed) {
                for (String element : object) {
                    if (!element.equalsIgnoreCase(check)) continue;
                    ++gotten;
                    continue block0;
                }
            }
            return new ElementTag(gotten == needed.size() && gotten > 0);
        }, new String[0]);
        ListTag.registerTag("random", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            if (attribute.hasContext(1)) {
                int count = Integer.valueOf(attribute.getContext(1));
                ArrayList<ObjectTag> available = new ArrayList<ObjectTag>(object.objectForms);
                ListTag toReturn = new ListTag();
                for (int times = 0; !available.isEmpty() && times < count; ++times) {
                    int random = CoreUtilities.getRandom().nextInt(available.size());
                    toReturn.addObject(available.get(random));
                    available.remove(random);
                }
                return toReturn;
            }
            return object.objectForms.get(CoreUtilities.getRandom().nextInt(object.size()));
        }, new String[0]);
        ListTag.registerTag("closest_to", (attribute, object) -> new ElementTag(CoreUtilities.getClosestOption(object, attribute.getContext(1))), new String[0]);
        ListTag.registerTag("as_list", (attribute, object) -> new ListTag((ListTag)object), "aslist");
        ListTag.registerTag("type", (attribute, object) -> new ElementTag("List"), new String[0]);
    }

    public boolean containsCaseInsensitive(String val) {
        val = CoreUtilities.toLowerCase(val);
        for (String str : this) {
            if (!CoreUtilities.toLowerCase(str).equals(val)) continue;
            return true;
        }
        return false;
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<ListTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        return this.flag != null && this.size() == 1 ? this.getObject(0) : new ElementTag(this.identifyList());
    }

    @Override
    public ObjectTag specialTagProcessing(Attribute attribute) {
        int index;
        String attrLow = attribute.getAttributeWithoutContext(1);
        if (Debug.verbose) {
            Debug.log("ListTag alternate attribute " + attrLow);
        }
        if (ArgumentHelper.matchesInteger(attrLow) && (index = Integer.parseInt(attrLow)) != 0) {
            attribute.fulfill(1);
            if (index < 1 || index > this.size()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("ListTag index " + index + " is out of range");
                }
                return null;
            }
            return this.getObject(index - 1);
        }
        return null;
    }
}

