/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.core.Delayable;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class QueueCommand
extends AbstractCommand {
    public QueueCommand() {
        this.setName("queue");
        this.setSyntax("queue (<queue>) [clear/stop/pause/resume/delay:<duration>]");
        this.setRequiredArguments(1, 2);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                if (scriptEntry.getObject("action") != Action.DELAY || !arg.matchesArgumentType(DurationTag.class)) continue;
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if ((arg.matchesArgumentType(QueueTag.class) || arg.matchesPrefix("queue")) && !scriptEntry.hasObject("queue")) {
                scriptEntry.addObject("queue", arg.asType(QueueTag.class));
                continue;
            }
            throw new InvalidArgumentsException("The specified queue could not be found: " + arg.raw_value);
        }
        scriptEntry.defaultObject("queue", new QueueTag(scriptEntry.getResidingQueue()));
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action. Valid: CLEAR, DELAY, PAUSE, RESUME");
        }
        if (scriptEntry.getObject("action") == Action.DELAY && !scriptEntry.hasObject("delay")) {
            throw new InvalidArgumentsException("Must specify a delay.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        QueueTag queue = (QueueTag)scriptEntry.getObject("queue");
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        DurationTag delay = (DurationTag)scriptEntry.getObject("delay");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), queue.debug() + ArgumentHelper.debugObj("Action", action.toString()) + (action == Action.DELAY ? delay.debug() : ""));
        }
        switch (action) {
            case CLEAR: {
                queue.queue.clear();
                return;
            }
            case STOP: {
                queue.queue.clear();
                queue.queue.stop();
                return;
            }
            case PAUSE: {
                if (queue.queue instanceof Delayable) {
                    ((Delayable)((Object)queue.queue)).setPaused(true);
                } else {
                    queue.queue.forceToTimed(new DurationTag(1L)).setPaused(true);
                }
                return;
            }
            case RESUME: {
                if (queue.queue instanceof Delayable) {
                    ((Delayable)((Object)queue.queue)).setPaused(false);
                }
                return;
            }
            case DELAY: {
                if (queue.queue instanceof Delayable) {
                    ((Delayable)((Object)queue.queue)).delayFor(delay);
                } else {
                    queue.queue.forceToTimed(delay);
                }
                return;
            }
        }
    }

    private static enum Action {
        CLEAR,
        DELAY,
        PAUSE,
        RESUME,
        STOP;

    }
}

