/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;

public class DeltaTimeScriptEvent
extends ScriptEvent {
    public static DeltaTimeScriptEvent instance;
    public ScriptEntryData data = null;
    public ElementTag second;
    boolean enabled = false;

    public DeltaTimeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("delta time");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        int count;
        String time = path.rawEventArgAt(2);
        long seconds = DenizenCore.serverTimeMillis / 1000L;
        String countString = path.switches.get("every");
        int n = count = countString == null ? 1 : Integer.parseInt(countString);
        if (time.equals("secondly")) {
            return seconds % (long)count == 0L;
        }
        if (time.equals("minutely")) {
            if (seconds % 60L != 0L) {
                return false;
            }
            long minutes = seconds / 60L;
            return minutes % (long)count == 0L;
        }
        if (time.equals("hourly")) {
            if (seconds % 3600L != 0L) {
                return false;
            }
            long hours = seconds / 3600L;
            return hours % (long)count == 0L;
        }
        return false;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.data;
    }

    @Override
    public String getName() {
        return "DeltaTime";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("second")) {
            return this.second;
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.enabled = false;
    }

    public void checkTime() {
        if (!this.enabled) {
            return;
        }
        this.second = new ElementTag(DenizenCore.serverTimeMillis / 1000L);
        this.data = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.fire();
    }
}

