/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashSet;

public class DebugCommand
extends AbstractCommand {
    public static HashSet<String> DBINFO = Argument.precalcEnum(DebugType.values());

    public DebugCommand() {
        this.setName("debug");
        this.setSyntax("debug [<type>] [<message>] (name:<name>)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(DBINFO)) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("debug")) {
                scriptEntry.addObject("debug", new ElementTag(arg.raw_value));
                continue;
            }
            if (!scriptEntry.hasObject("name") && arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("type") || !scriptEntry.hasObject("debug")) {
            throw new InvalidArgumentsException("Must specify a definition and value!");
        }
        scriptEntry.defaultObject("name", new ElementTag("name"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag debug = scriptEntry.getElement("debug");
        ElementTag type = scriptEntry.getElement("type");
        ElementTag name = scriptEntry.getElement("name");
        switch (DebugType.valueOf(type.asString().toUpperCase())) {
            case DEBUG: {
                Debug.echoDebug((Debuggable)scriptEntry, debug.asString());
                break;
            }
            case HEADER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, debug.asString());
                break;
            }
            case FOOTER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Footer, debug.asString());
                break;
            }
            case SPACER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Spacer, debug.asString());
                break;
            }
            case LOG: {
                Debug.log(debug.asString());
                break;
            }
            case APPROVAL: {
                Debug.echoApproval(debug.asString());
                break;
            }
            case ERROR: {
                Debug.echoError(scriptEntry.getResidingQueue(), debug.asString());
                break;
            }
            case REPORT: {
                if (!scriptEntry.dbCallShouldDebug()) break;
                Debug.report(scriptEntry, name.asString(), debug.asString());
                break;
            }
            case EXCEPTION: {
                Debug.echoError(scriptEntry.getResidingQueue(), new RuntimeException(debug.asString()));
            }
        }
    }

    public static enum DebugType {
        DEBUG,
        HEADER,
        FOOTER,
        SPACER,
        LOG,
        APPROVAL,
        ERROR,
        REPORT,
        EXCEPTION;

    }
}

