/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;

public class QueueTagBase {
    public QueueTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                QueueTagBase.this.queueTag(event);
            }
        }, "queue", "q");
    }

    public void queueTag(ReplaceableTagEvent event) {
        if (!event.matches("queue", "q")) {
            return;
        }
        if (event.matches("q")) {
            Deprecations.queueShorthand.warn(event.getScriptEntry());
        }
        if (event.hasNameContext()) {
            if (!ScriptQueue.queueExists(event.getNameContext())) {
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new QueueTag(ScriptQueue.getExistingQueue(event.getNameContext())), event.getAttributes().fulfill(1)));
            return;
        }
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("exists") && attribute.hasContext(1)) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(ScriptQueue.queueExists(attribute.getContext(1))), attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("stats")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(ScriptQueue.getStats()), attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list")) {
            ListTag list = new ListTag();
            for (ScriptQueue queue : ScriptQueue.getQueues()) {
                list.addObject(new QueueTag(queue));
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(list, attribute.fulfill(1)));
            return;
        }
        event.setReplacedObject(CoreUtilities.autoAttrib(new QueueTag(event.getScriptEntry().getResidingQueue()), attribute));
    }
}

