/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class DurationTag
implements ObjectTag {
    public static final DurationTag ZERO = new DurationTag(0);
    private double seconds;
    private String prefix = "Duration";
    public static ObjectTagProcessor<DurationTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static DurationTag valueOf(String string) {
        return DurationTag.valueOf(string, null);
    }

    @Fetchable(value="d")
    public static DurationTag valueOf(String string, TagContext context) {
        String[] split;
        if (string == null) {
            return null;
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("d@")) {
            string = string.substring("d@".length());
        }
        if (string.equals("instant") || string.equals("infinite")) {
            return new DurationTag(0);
        }
        if (string.isEmpty()) {
            return null;
        }
        if (string.contains("-") && !string.contains("e-") && (split = string.split("-", 2)).length == 2) {
            DurationTag low = DurationTag.valueOf(split[0], context);
            DurationTag high = DurationTag.valueOf(split[1], context);
            if (low != null && high != null) {
                if (high.getSecondsAsInt() < low.getSecondsAsInt()) {
                    DurationTag temp = low;
                    low = high;
                    high = temp;
                }
                int seconds = CoreUtilities.getRandom().nextInt(high.getSecondsAsInt() - low.getSecondsAsInt() + 1) + low.getSecondsAsInt();
                if (Debug.verbose) {
                    Debug.log("Getting random duration between " + low.identify() + " and " + high.identify() + "... " + seconds + "s");
                }
                return new DurationTag(seconds);
            }
            return null;
        }
        String numericString = Character.isDigit(string.charAt(string.length() - 1)) ? string : string.substring(0, string.length() - 1);
        try {
            if (string.endsWith("t")) {
                return new DurationTag(Double.valueOf(numericString) * 0.05);
            }
            if (string.endsWith("d")) {
                return new DurationTag(Double.valueOf(numericString) * 86400.0);
            }
            if (string.endsWith("w")) {
                return new DurationTag(Double.valueOf(numericString) * 604800.0);
            }
            if (string.endsWith("m")) {
                return new DurationTag(Double.valueOf(numericString) * 60.0);
            }
            if (string.endsWith("h")) {
                return new DurationTag(Double.valueOf(numericString) * 3600.0);
            }
            if (string.endsWith("s")) {
                return new DurationTag(Double.valueOf(numericString));
            }
            if (numericString.equals(string)) {
                return new DurationTag(Double.valueOf(numericString));
            }
            if (context == null || context.debug) {
                Debug.echoError("Duration type '" + string + "' is not valid.");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        try {
            return DurationTag.valueOf(string, CoreUtilities.noDebugContext) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public DurationTag(double seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public DurationTag(int seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public DurationTag(long ticks) {
        this.seconds = (double)ticks / 20.0;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public long getTicks() {
        return (long)(this.seconds * 20.0);
    }

    public int getTicksAsInt() {
        return (int)(this.seconds * 20.0);
    }

    public long getMillis() {
        Double millis = this.seconds * 1000.0;
        return millis.longValue();
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSecondsAsInt() {
        if (this.seconds < 1.0 && this.seconds > 0.0) {
            return 1;
        }
        return this.round(this.seconds);
    }

    private int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        return "d@" + this.seconds + "s <GR>(" + this.formatted() + ")";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "duration";
    }

    @Override
    public String identify() {
        return "d@" + this.seconds + "s";
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        DurationTag.registerTag("in_years", (attribute, object) -> new ElementTag(object.seconds / 3.1536E7), "years");
        DurationTag.registerTag("in_weeks", (attribute, object) -> new ElementTag(object.seconds / 604800.0), "weeks");
        DurationTag.registerTag("in_days", (attribute, object) -> new ElementTag(object.seconds / 86400.0), "days");
        DurationTag.registerTag("in_hours", (attribute, object) -> new ElementTag(object.seconds / 3600.0), "hours");
        DurationTag.registerTag("in_minutes", (attribute, object) -> new ElementTag(object.seconds / 60.0), "minutes");
        DurationTag.registerTag("in_seconds", (attribute, object) -> new ElementTag(object.seconds), "seconds");
        DurationTag.registerTag("in_milliseconds", (attribute, object) -> new ElementTag(object.seconds * 1000.0), "milliseconds");
        DurationTag.registerTag("in_ticks", (attribute, object) -> new ElementTag((long)(object.seconds * 20.0)), "ticks");
        DurationTag.registerTag("sub", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag DurationTag.sub[...] must have a value.");
                return null;
            }
            return new DurationTag(object.getTicks() - attribute.contextAsType(1, DurationTag.class).getTicks());
        }, new String[0]);
        DurationTag.registerTag("add", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag DurationTag.add[...] must have a value.");
                return null;
            }
            return new DurationTag(object.getTicks() + attribute.contextAsType(1, DurationTag.class).getTicks());
        }, new String[0]);
        DurationTag.registerTag("time", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            return new TimeTag(object.getMillis());
        }, new String[0]);
        DurationTag.registerTag("formatted", (attribute, object) -> new ElementTag(object.formatted()), "value");
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<DurationTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public String formatted() {
        long seconds = (long)this.seconds;
        long days = seconds / 86400L;
        long hours = (seconds - days * 86400L) / 3600L;
        long minutes = (seconds - days * 86400L - hours * 3600L) / 60L;
        seconds = seconds - days * 86400L - hours * 3600L - minutes * 60L;
        String timeString = "";
        if (days > 0L) {
            timeString = days + "d ";
        }
        if (hours > 0L) {
            timeString = timeString + hours + "h ";
        }
        if (minutes > 0L && days == 0L) {
            timeString = timeString + minutes + "m ";
        }
        if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L) {
            timeString = timeString + seconds + "s";
        }
        if (timeString.isEmpty()) {
            timeString = this.seconds <= 0.0 ? "forever" : (double)((long)(this.seconds * 100.0)) / 100.0 + "s";
        }
        return timeString.trim();
    }
}

