/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.ItemSerializer;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.VersionedComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;

public class HoverFormatHelper {
    public static boolean processHoverInput(HoverEvent.Action action, TextComponent hoverableText, String input) {
        Object content;
        if (action == HoverEvent.Action.SHOW_ITEM) {
            com.denizenscript.denizen.objects.ItemTag item = com.denizenscript.denizen.objects.ItemTag.valueOf(FormattedTextHelper.unescape(input), CoreUtilities.noDebugContext);
            if (item == null) {
                return true;
            }
            content = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) ? new FixedItemHover(item.getBukkitMaterial().getKey().toString(), item.getAmount(), NMSHandler.itemHelper.getRawHoverComponentsJson(item.getItemStack())) : new Item(item.getBukkitMaterial().getKey().toString(), item.getAmount(), ItemTag.ofNbt((String)NMSHandler.itemHelper.getLegacyHoverNbt(item)));
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            EntityTag entity = EntityTag.valueOf(FormattedTextHelper.unescape(input), CoreUtilities.basicContext);
            if (entity == null) {
                return true;
            }
            TextComponent name = null;
            if (entity.getBukkitEntity() != null && entity.getBukkitEntity().isCustomNameVisible()) {
                name = new TextComponent();
                for (BaseComponent component : FormattedTextHelper.parse(entity.getBukkitEntity().getCustomName(), ChatColor.WHITE)) {
                    name.addExtra(component);
                }
            }
            content = new Entity(entity.getBukkitEntityType().getKey().toString(), entity.getUUID().toString(), (BaseComponent)name);
        } else {
            content = new Text(FormattedTextHelper.parse(FormattedTextHelper.unescape(input), ChatColor.WHITE));
        }
        hoverableText.setHoverEvent(new HoverEvent(action, new Content[]{content}));
        return false;
    }

    public static String stringForHover(HoverEvent hover) {
        if (hover.getContents().isEmpty()) {
            return "";
        }
        Content contentObject = (Content)hover.getContents().get(0);
        if (contentObject instanceof Text) {
            Text textHover = (Text)contentObject;
            Object value = textHover.getValue();
            if (value instanceof BaseComponent[]) {
                BaseComponent[] componentsValue = (BaseComponent[])value;
                return FormattedTextHelper.stringify(componentsValue);
            }
            return value.toString();
        }
        if (contentObject instanceof Item) {
            FixedItemHover fixedItemHover;
            Item itemHover = (Item)contentObject;
            ItemStack item = new ItemStack((Material)Registry.MATERIAL.get(Utilities.parseNamespacedKey(itemHover.getId())), itemHover.getCount() == -1 ? 1 : itemHover.getCount());
            if (itemHover instanceof FixedItemHover && (fixedItemHover = (FixedItemHover)itemHover).getComponents() != null) {
                item = NMSHandler.itemHelper.applyRawHoverComponentsJson(item, fixedItemHover.getComponents());
            } else if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_19) && itemHover.getTag() != null && itemHover.getTag().getNbt() != null) {
                item = Bukkit.getUnsafe().modifyItemStack(item, itemHover.getTag().getNbt());
            }
            return new com.denizenscript.denizen.objects.ItemTag(item).identify();
        }
        if (contentObject instanceof Entity) {
            Entity entityHover = (Entity)contentObject;
            return "e@" + entityHover.getId();
        }
        throw new UnsupportedOperationException();
    }

    public static void tryInitializeItemHoverFix() {
        if (!NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
            return;
        }
        Gson bungeeGson = FormattedTextHelper.getBungeeGson();
        if (bungeeGson == null) {
            return;
        }
        Gson fixedGson = bungeeGson.newBuilder().registerTypeAdapter(FixedItemHover.class, (Object)new FixedItemHoverSerializer()).registerTypeAdapter(Item.class, (Object)new FixedItemHoverSerializer()).create();
        try {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
                ReflectionHelper.setFieldValue(VersionedComponentSerializer.class, "gson", VersionedComponentSerializer.forVersion((ChatVersion)ChatVersion.V1_21_5), fixedGson);
            } else {
                ReflectionHelper.getFinalSetter(ComponentSerializer.class, "gson").invoke(fixedGson);
            }
        }
        catch (Throwable e) {
            Debug.echoError(e);
        }
    }

    public static class FixedItemHover
    extends Item {
        private final JsonObject components;

        public FixedItemHover(String id, int count, JsonObject components) {
            super(id, count, null);
            this.components = components;
        }

        public JsonObject getComponents() {
            return this.components;
        }
    }

    public static class FixedItemHoverSerializer
    extends ItemSerializer {
        public Item deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            Item deserialized = super.deserialize(element, type, context);
            if (deserialized.getTag() != null) {
                return deserialized;
            }
            JsonObject componentsObject = element.getAsJsonObject().getAsJsonObject("components");
            if (componentsObject == null) {
                return deserialized;
            }
            return new FixedItemHover(deserialized.getId(), deserialized.getCount(), componentsObject);
        }

        public JsonElement serialize(Item content, Type type, JsonSerializationContext context) {
            FixedItemHover fixedItemHover;
            JsonElement serialized = super.serialize(content, type, context);
            if (!(content instanceof FixedItemHover) || (fixedItemHover = (FixedItemHover)content).getComponents() == null) {
                return serialized;
            }
            JsonObject serializedObject = serialized.getAsJsonObject();
            serializedObject.remove("tag");
            serializedObject.add("components", (JsonElement)fixedItemHover.getComponents());
            return serializedObject;
        }
    }
}

