/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.FakeBlockHelper;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.World;

public class FakeBlocksPacketHandlers {
    public static Field SECTIONPOS_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_sectionPos, SectionPosition.class);
    public static Field OFFSETARRAY_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_positions, short[].class);
    public static Field BLOCKARRAY_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_states, IBlockData[].class);

    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(ClientboundLevelChunkWithLightPacket.class, FakeBlocksPacketHandlers::processShowFakeForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutMultiBlockChange.class, FakeBlocksPacketHandlers::processShowFakeForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutBlockChange.class, FakeBlocksPacketHandlers::processShowFakeForPacket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Packet<PacketListenerPlayOut> processShowFakeForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (FakeBlock.blocks.isEmpty()) {
            return packet;
        }
        try {
            if (packet instanceof ClientboundLevelChunkWithLightPacket) {
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(networkManager.player.cz());
                if (map == null) {
                    return packet;
                }
                int chunkX = ((ClientboundLevelChunkWithLightPacket)packet).b();
                int chunkZ = ((ClientboundLevelChunkWithLightPacket)packet).e();
                ChunkCoordinate chunkCoord = new ChunkCoordinate(chunkX, chunkZ, networkManager.player.dP().getWorld().getName());
                List<FakeBlock> blocks = FakeBlock.getFakeBlocksFor(networkManager.player.cz(), chunkCoord);
                if (blocks == null) return packet;
                if (!blocks.isEmpty()) return FakeBlockHelper.handleMapChunkPacket(networkManager.player.getBukkitEntity().getWorld(), (ClientboundLevelChunkWithLightPacket)packet, chunkX, chunkZ, blocks);
                return packet;
            }
            if (packet instanceof PacketPlayOutMultiBlockChange) {
                PacketPlayOutMultiBlockChange sectionBlocksUpdatePacket = (PacketPlayOutMultiBlockChange)packet;
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(networkManager.player.cz());
                if (map == null) {
                    return sectionBlocksUpdatePacket;
                }
                SectionPosition coord = (SectionPosition)SECTIONPOS_MULTIBLOCKCHANGE.get(sectionBlocksUpdatePacket);
                ChunkCoordinate coordinateDenizen = new ChunkCoordinate(coord.u(), coord.w(), networkManager.player.dP().getWorld().getName());
                if (!map.byChunk.containsKey(coordinateDenizen)) {
                    return sectionBlocksUpdatePacket;
                }
                PacketPlayOutMultiBlockChange newPacket = DenizenNetworkManagerImpl.copyPacket(sectionBlocksUpdatePacket, PacketPlayOutMultiBlockChange.a);
                LocationTag location = new LocationTag((World)networkManager.player.dP().getWorld(), 0.0, 0.0, 0.0);
                short[] originalOffsetArray = (short[])OFFSETARRAY_MULTIBLOCKCHANGE.get(newPacket);
                IBlockData[] originalDataArray = (IBlockData[])BLOCKARRAY_MULTIBLOCKCHANGE.get(newPacket);
                short[] offsetArray = Arrays.copyOf(originalOffsetArray, originalOffsetArray.length);
                IBlockData[] dataArray = Arrays.copyOf(originalDataArray, originalDataArray.length);
                OFFSETARRAY_MULTIBLOCKCHANGE.set(newPacket, offsetArray);
                BLOCKARRAY_MULTIBLOCKCHANGE.set(newPacket, dataArray);
                int i = 0;
                while (i < offsetArray.length) {
                    short offset = offsetArray[i];
                    BlockPosition pos = coord.g(offset);
                    location.setX(pos.u());
                    location.setY(pos.v());
                    location.setZ(pos.w());
                    FakeBlock block = map.byLocation.get(location);
                    if (block != null) {
                        dataArray[i] = FakeBlockHelper.getNMSState(block);
                    }
                    ++i;
                }
                return newPacket;
            }
            if (packet instanceof PacketPlayOutBlockChange) {
                BlockPosition pos = ((PacketPlayOutBlockChange)packet).e();
                LocationTag loc = new LocationTag((World)networkManager.player.dP().getWorld(), (double)pos.u(), (double)pos.v(), pos.w());
                FakeBlock block = FakeBlock.getFakeBlockFor(networkManager.player.cz(), loc);
                if (block == null) return packet;
                return new PacketPlayOutBlockChange(((PacketPlayOutBlockChange)packet).e(), FakeBlockHelper.getNMSState(block));
            }
            if (!(packet instanceof ClientboundBlockChangedAckPacket)) return packet;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        return packet;
    }
}

