/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Wolf;

public class EntityVariant
extends EntityProperty<ElementTag> {
    public static final MethodHandle COW_GET_VARIANT;
    public static final MethodHandle COW_SET_VARIANT;

    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Wolf || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && entity.getBukkitEntity() instanceof Chicken || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && entity.getBukkitEntity() instanceof Cow || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && entity.getBukkitEntity() instanceof Pig;
    }

    @Override
    public ElementTag getPropertyValue() {
        Entity entity = this.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            return new ElementTag(Utilities.namespacedKeyToString(wolf.getVariant().getKey()), true);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (entity = this.getEntity()) instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            return new ElementTag(Utilities.namespacedKeyToString(chicken.getVariant().getKey()), true);
        }
        if (COW_GET_VARIANT != null && (entity = this.getEntity()) instanceof Cow) {
            Cow cow = (Cow)entity;
            try {
                return new ElementTag(Utilities.namespacedKeyToString(COW_GET_VARIANT.invoke(cow).getKey()), true);
            }
            catch (Throwable e) {
                Debug.echoError(e);
                return null;
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (entity = this.getEntity()) instanceof Pig) {
            Pig pig = (Pig)entity;
            return new ElementTag(Utilities.namespacedKeyToString(pig.getVariant().getKey()), true);
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag variant, Mechanism mechanism) {
        Entity cowVariant;
        Entity chickenVariant;
        Entity wolfVariant;
        Entity entity = this.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolfVariant = Utilities.elementToRequiredEnumLike(variant, Wolf.Variant.class, mechanism);
            if (wolfVariant != null) {
                wolf.setVariant((Wolf.Variant)wolfVariant);
            }
        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (wolfVariant = this.getEntity()) instanceof Chicken) {
            Chicken chicken = (Chicken)wolfVariant;
            chickenVariant = Utilities.elementToRequiredEnumLike(variant, Chicken.Variant.class, mechanism);
            if (chickenVariant != null) {
                chicken.setVariant((Chicken.Variant)chickenVariant);
            }
        } else if (COW_SET_VARIANT != null && (chickenVariant = this.getEntity()) instanceof Cow) {
            Cow cow = (Cow)chickenVariant;
            cowVariant = Utilities.elementToRequiredEnumLike(variant, Cow.Variant.class, mechanism);
            if (cowVariant != null) {
                try {
                    COW_SET_VARIANT.invoke(cow, (Cow.Variant)cowVariant);
                }
                catch (Throwable e) {
                    Debug.echoError(e);
                }
            }
        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (cowVariant = this.getEntity()) instanceof Pig) {
            Pig pig = (Pig)cowVariant;
            Pig.Variant pigVariant = Utilities.elementToRequiredEnumLike(variant, Pig.Variant.class, mechanism);
            if (pigVariant != null) {
                pig.setVariant(pigVariant);
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "variant";
    }

    public static void register() {
        EntityVariant.autoRegister("variant", EntityVariant.class, ElementTag.class, false, new String[0]);
    }

    static {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            Class<?> cowClass = ReflectionHelper.getClassOrThrow("org.bukkit.entity.Cow");
            COW_GET_VARIANT = ReflectionHelper.getMethodHandle(cowClass, "getVariant", new Class[0]);
            COW_SET_VARIANT = ReflectionHelper.getMethodHandle(cowClass, "setVariant", Cow.Variant.class);
        } else {
            COW_GET_VARIANT = null;
            COW_SET_VARIANT = null;
        }
    }
}

