/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.MoistureChangeEvent;

public class MoistureChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public MoistureChangeEvent event;
    public LocationTag location;
    public Farmland oldFarmland;
    public Farmland newFarmland;

    public MoistureChangeScriptEvent() {
        this.registerCouldMatcher("farmland moisture level changes");
        this.registerSwitches("from", "to");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.checkSwitch("from", String.valueOf(this.oldFarmland.getMoisture()))) {
            return false;
        }
        if (!path.checkSwitch("to", String.valueOf(this.newFarmland.getMoisture()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "material" -> new MaterialTag((BlockData)this.oldFarmland);
            case "old_level" -> new ElementTag(this.oldFarmland.getMoisture());
            case "new_level" -> new ElementTag(this.newFarmland.getMoisture());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onMoistureChange(MoistureChangeEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.oldFarmland = (Farmland)event.getBlock().getBlockData();
        this.newFarmland = (Farmland)event.getNewState().getBlockData();
        this.event = event;
        this.fire((Event)event);
    }
}

