/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.vehicle;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class VehicleCollidesEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public VehicleEntityCollisionEvent event;
    public EntityTag vehicle;
    public EntityTag entity;

    public VehicleCollidesEntityScriptEvent() {
        this.registerCouldMatcher("<vehicle> collides with <entity>");
        this.registerSwitches("type");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.vehicle)) {
            return false;
        }
        if (!path.tryArgObject(3, this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        if (!path.tryObjectSwitch("type", this.entity)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("pickup:")) {
            this.event.setPickupCancelled(!new ElementTag(lower.substring("pickup:".length())).asBoolean());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "vehicle": {
                return this.vehicle;
            }
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "pickup": {
                return new ElementTag(!this.event.isPickupCancelled());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleCollidesEntity(VehicleEntityCollisionEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.event = event;
        this.fire((Event)event);
    }
}

