/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.GlowSquid;

public class EntityDarkDuration
implements Property {
    public static final String[] handledMechs = new String[]{"dark_duration"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof GlowSquid;
    }

    public static EntityDarkDuration getFrom(ObjectTag entity) {
        if (!EntityDarkDuration.describes(entity)) {
            return null;
        }
        return new EntityDarkDuration((EntityTag)entity);
    }

    public EntityDarkDuration(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return new DurationTag((long)this.getGlowSquid().getDarkTicksRemaining()).identify();
    }

    @Override
    public String getPropertyId() {
        return "dark_duration";
    }

    public GlowSquid getGlowSquid() {
        return (GlowSquid)this.entity.getBukkitEntity();
    }

    public static void register() {
        PropertyParser.registerTag(EntityDarkDuration.class, DurationTag.class, "dark_duration", (attribute, object) -> new DurationTag((long)object.getGlowSquid().getDarkTicksRemaining()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("dark_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getGlowSquid().setDarkTicksRemaining(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
    }
}

