/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.BigDripleaf;
import org.bukkit.block.data.type.BubbleColumn;
import org.bukkit.block.data.type.CommandBlock;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.block.data.type.DaylightDetector;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.SculkCatalyst;
import org.bukkit.block.data.type.SculkSensor;
import org.bukkit.block.data.type.SculkShrieker;
import org.bukkit.block.data.type.StructureBlock;
import org.bukkit.block.data.type.Tripwire;

public class MaterialMode
implements Property {
    public static final String[] handledMechs = new String[]{"mode"};
    public MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Comparator || data instanceof PistonHead || data instanceof BubbleColumn || data instanceof StructureBlock || data instanceof DaylightDetector || data instanceof CommandBlock || data instanceof SculkSensor || data instanceof BigDripleaf || data instanceof Tripwire || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (data instanceof SculkCatalyst || data instanceof SculkShrieker);
    }

    public static MaterialMode getFrom(ObjectTag _material) {
        if (!MaterialMode.describes(_material)) {
            return null;
        }
        return new MaterialMode((MaterialTag)_material);
    }

    public MaterialMode(MaterialTag _material) {
        this.material = _material;
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialMode.class, ElementTag.class, "mode", (attribute, material) -> new ElementTag(material.getPropertyString()), new String[0]);
    }

    public boolean isComparator() {
        return this.material.getModernData() instanceof Comparator;
    }

    public boolean isPistonHead() {
        return this.material.getModernData() instanceof PistonHead;
    }

    public boolean isBubbleColumn() {
        return this.material.getModernData() instanceof BubbleColumn;
    }

    public boolean isStructureBlock() {
        return this.material.getModernData() instanceof StructureBlock;
    }

    public boolean isDaylightDetector() {
        return this.material.getModernData() instanceof DaylightDetector;
    }

    public boolean isCommandBlock() {
        return this.material.getModernData() instanceof CommandBlock;
    }

    public boolean isSculkSensor() {
        return this.material.getModernData() instanceof SculkSensor;
    }

    public boolean isBigDripleaf() {
        return this.material.getModernData() instanceof BigDripleaf;
    }

    public boolean isTripwire() {
        return this.material.getModernData() instanceof Tripwire;
    }

    public boolean isSculkCatalyst() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && this.material.getModernData() instanceof SculkCatalyst;
    }

    public boolean isSculkShrieker() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && this.material.getModernData() instanceof SculkShrieker;
    }

    public Comparator getComparator() {
        return (Comparator)this.material.getModernData();
    }

    public PistonHead getPistonHead() {
        return (PistonHead)this.material.getModernData();
    }

    public BubbleColumn getBubbleColumn() {
        return (BubbleColumn)this.material.getModernData();
    }

    public StructureBlock getStructureBlock() {
        return (StructureBlock)this.material.getModernData();
    }

    public DaylightDetector getDaylightDetector() {
        return (DaylightDetector)this.material.getModernData();
    }

    public CommandBlock getCommandBlock() {
        return (CommandBlock)this.material.getModernData();
    }

    public SculkSensor getSculkSensor() {
        return (SculkSensor)this.material.getModernData();
    }

    public BigDripleaf getBigDripleaf() {
        return (BigDripleaf)this.material.getModernData();
    }

    public Tripwire getTripwire() {
        return (Tripwire)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        if (this.isComparator()) {
            return this.getComparator().getMode().name();
        }
        if (this.isBubbleColumn()) {
            return this.getBubbleColumn().isDrag() ? "DRAG" : "NORMAL";
        }
        if (this.isPistonHead()) {
            return this.getPistonHead().isShort() ? "SHORT" : "NORMAL";
        }
        if (this.isStructureBlock()) {
            return this.getStructureBlock().getMode().name();
        }
        if (this.isDaylightDetector()) {
            return this.getDaylightDetector().isInverted() ? "INVERTED" : "NORMAL";
        }
        if (this.isCommandBlock()) {
            return this.getCommandBlock().isConditional() ? "CONDITIONAL" : "NORMAL";
        }
        if (this.isSculkSensor()) {
            return this.getSculkSensor().getPhase().name();
        }
        if (this.isBigDripleaf()) {
            return this.getBigDripleaf().getTilt().name();
        }
        if (this.isTripwire()) {
            return this.getTripwire().isDisarmed() ? "DISARMED" : "ARMED";
        }
        if (this.isSculkCatalyst()) {
            return ((SculkCatalyst)this.material.getModernData()).isBloom() ? "BLOOM" : "NORMAL";
        }
        if (this.isSculkShrieker()) {
            return ((SculkShrieker)this.material.getModernData()).isShrieking() ? "SHRIEKING" : "NORMAL";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "mode";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("mode")) {
            if (this.isComparator() && mechanism.requireEnum(Comparator.Mode.class)) {
                this.getComparator().setMode(Comparator.Mode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isBubbleColumn()) {
                this.getBubbleColumn().setDrag(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "drag"));
            } else if (this.isPistonHead()) {
                this.getPistonHead().setShort(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "short"));
            } else if (this.isStructureBlock() && mechanism.requireEnum(StructureBlock.Mode.class)) {
                this.getStructureBlock().setMode(StructureBlock.Mode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isDaylightDetector()) {
                this.getDaylightDetector().setInverted(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "inverted"));
            } else if (this.isCommandBlock()) {
                this.getCommandBlock().setConditional(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "conditional"));
            } else if (this.isSculkSensor() && mechanism.requireEnum(SculkSensor.Phase.class)) {
                this.getSculkSensor().setPhase(SculkSensor.Phase.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isBigDripleaf() && mechanism.requireEnum(BigDripleaf.Tilt.class)) {
                this.getBigDripleaf().setTilt(BigDripleaf.Tilt.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isTripwire()) {
                this.getTripwire().setDisarmed(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "disarmed"));
            } else if (this.isSculkCatalyst()) {
                ((SculkCatalyst)this.material.getModernData()).setBloom(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "bloom"));
            } else if (this.isSculkShrieker()) {
                ((SculkShrieker)this.material.getModernData()).setShrieking(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "shrieking"));
            }
        }
    }
}

