/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.paper.PaperModule;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Arrays;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.command.UnknownCommandEvent;

public class UnknownCommandScriptEvent
extends BukkitScriptEvent
implements Listener {
    public UnknownCommandEvent event;
    public String command;
    public String rawArgs;
    public String sourceType;

    public UnknownCommandScriptEvent() {
        this.registerCouldMatcher("command unknown");
        this.registerDetermination(null, ElementTag.class, (evt, context, text) -> evt.event.message(PaperModule.parseFormattedText(text.toString(), ChatColor.WHITE)));
        this.registerTextDetermination("none", evt -> evt.event.message(null));
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        PlayerTag playerTag;
        CommandSender commandSender = this.event.getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            playerTag = new PlayerTag(player);
        } else {
            playerTag = null;
        }
        return new BukkitScriptEntryData(playerTag, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "command" -> new ElementTag(this.command, true);
            case "raw_args" -> new ElementTag(this.rawArgs, true);
            case "args" -> new ListTag(Arrays.asList(ArgumentHelper.buildArgs(this.rawArgs, false)), true);
            case "server" -> new ElementTag(this.sourceType.equals("server"));
            case "source_type" -> new ElementTag(this.sourceType, true);
            case "command_block_location" -> {
                if (this.sourceType.equals("command_block")) {
                    yield new LocationTag(((BlockCommandSender)this.event.getSender()).getBlock().getLocation());
                }
                yield null;
            }
            case "command_minecart" -> {
                if (this.sourceType.equals("command_minecart")) {
                    yield new EntityTag((Entity)((CommandMinecart)this.event.getSender()));
                }
                yield null;
            }
            case "message" -> new ElementTag(PaperModule.stringifyComponent(this.event.message()), true);
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void unknownCommandEvent(UnknownCommandEvent event) {
        this.event = event;
        String[] splitCommand = event.getCommandLine().split(" ", 2);
        this.command = splitCommand[0];
        String string = this.rawArgs = splitCommand.length > 1 ? splitCommand[1] : "";
        this.sourceType = event.getSender() instanceof Player ? "player" : (event.getSender() instanceof BlockCommandSender ? "command_block" : (event.getSender() instanceof CommandMinecart ? "command_minecart" : "server"));
        this.fire((Event)event);
    }
}

